/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeOptionGroupsRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Filter;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class DescribeOptionGroupsRequestMarshaller
implements Marshaller<Request<DescribeOptionGroupsRequest>, DescribeOptionGroupsRequest> {
    @Override
    public Request<DescribeOptionGroupsRequest> marshall(DescribeOptionGroupsRequest describeOptionGroupsRequest) {
        if (describeOptionGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeOptionGroupsRequest> request = new DefaultRequest<DescribeOptionGroupsRequest>(describeOptionGroupsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeOptionGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOptionGroupsRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(describeOptionGroupsRequest.getOptionGroupName()));
        }
        if (!describeOptionGroupsRequest.getFilters().isEmpty() || !((SdkInternalList)describeOptionGroupsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeOptionGroupsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOptionGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeOptionGroupsRequest.getMarker()));
        }
        if (describeOptionGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeOptionGroupsRequest.getMaxRecords()));
        }
        if (describeOptionGroupsRequest.getEngineName() != null) {
            request.addParameter("EngineName", StringUtils.fromString(describeOptionGroupsRequest.getEngineName()));
        }
        if (describeOptionGroupsRequest.getMajorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringUtils.fromString(describeOptionGroupsRequest.getMajorEngineVersion()));
        }
        return request;
    }
}

