/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.CreateGlobalClusterRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class CreateGlobalClusterRequestMarshaller
implements Marshaller<Request<CreateGlobalClusterRequest>, CreateGlobalClusterRequest> {
    @Override
    public Request<CreateGlobalClusterRequest> marshall(CreateGlobalClusterRequest createGlobalClusterRequest) {
        if (createGlobalClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateGlobalClusterRequest> request = new DefaultRequest<CreateGlobalClusterRequest>(createGlobalClusterRequest, "AmazonRDS");
        request.addParameter("Action", "CreateGlobalCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createGlobalClusterRequest.getGlobalClusterIdentifier() != null) {
            request.addParameter("GlobalClusterIdentifier", StringUtils.fromString(createGlobalClusterRequest.getGlobalClusterIdentifier()));
        }
        if (createGlobalClusterRequest.getSourceDBClusterIdentifier() != null) {
            request.addParameter("SourceDBClusterIdentifier", StringUtils.fromString(createGlobalClusterRequest.getSourceDBClusterIdentifier()));
        }
        if (createGlobalClusterRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString(createGlobalClusterRequest.getEngine()));
        }
        if (createGlobalClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(createGlobalClusterRequest.getEngineVersion()));
        }
        if (createGlobalClusterRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean(createGlobalClusterRequest.getDeletionProtection()));
        }
        if (createGlobalClusterRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString(createGlobalClusterRequest.getDatabaseName()));
        }
        if (createGlobalClusterRequest.getStorageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean(createGlobalClusterRequest.getStorageEncrypted()));
        }
        return request;
    }
}

