/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.apache.client.impl;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.AmazonHttpClient;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.IdleConnectionReaper;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.apache.SdkProxyRoutePlanner;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.apache.client.impl.SdkHttpClient;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.apache.utils.ApacheUtils;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.client.ConnectionManagerFactory;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.client.HttpClientFactory;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.conn.ClientConnectionManagerFactory;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.protocol.SdkHttpRequestExecutor;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.settings.HttpClientSettings;
import io.magj.iamjdbcdriver.repackaged.org.apache.commons.logging.Log;
import io.magj.iamjdbcdriver.repackaged.org.apache.commons.logging.LogFactory;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.conn.ConnectionKeepAliveStrategy;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.conn.HttpClientConnectionManager;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.impl.client.HttpClientBuilder;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            LOG.info("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort());
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getProxyProtocol(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }
}

