/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.AWSCredentialsProvider;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.AWSStaticCredentialsProvider;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.BasicAWSCredentials;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.profile.ProfileCredentialsProvider;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.profile.internal.securitytoken.STSProfileCredentialsServiceProvider;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.regions.AwsProfileRegionProvider;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.regions.DefaultAwsRegionProviderChain;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.auth.GetIamAuthTokenRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.auth.RdsIamAuthTokenGenerator;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class IamAuthJdbcDriverWrapper
implements Driver {
    private static final Logger LOGGER = Logger.getLogger(IamAuthJdbcDriverWrapper.class.getName());
    public static final String DELEGATE_DRIVER_CLASS_PROPERTY = "delegateJdbcDriverClass";
    public static final String DELEGATE_DRIVER_SCHEME_NAME_PROPERTY = "delegateJdbcDriverSchemeName";
    public static final String AWS_REGION_PROPERTY = "awsRegion";
    public static final String AWS_PROFILE_PROPERTY = "awsProfile";
    public static final String AWS_STS_CREDENTIAL_ROLE_ARN_PROPERTY = "awsStsCredentialProviderRoleArn";
    public static final String AWS_STS_CREDENTIAL_SESSION_NAME_PROPERTY = "awsStsCredentialProviderSessionName";
    public static final String AWS_STS_CREDENTIAL_EXTERNAL_ID_PROPERTY = "awsStsCredentialProviderExternalId";
    public static final String AWS_ACCESS_KEY_ID_PROPERTY = "awsAccessKeyId";
    public static final String AWS_SECRET_ACCESS_KEY_PROPERTY = "awsSecretAccessKey";
    public static final String DEFAULT_PASSWORD_PROPERTY = "password";
    public static final String DEFAULT_USER_PROPERTY = "user";
    private static final String JDBC_URL_PREFIX = "jdbc:";
    private final DefaultAwsRegionProviderChain defaultAwsRegionProviderChain = new DefaultAwsRegionProviderChain();
    private final DefaultAWSCredentialsProviderChain defaultAWSCredentialsProviderChain = DefaultAWSCredentialsProviderChain.getInstance();
    private final String wrapperSchemeName;
    private final String passwordProperty;
    private final String userProperty;
    private final Integer defaultPort;
    private final String driverClassName;
    private final boolean acceptDelegateUrls;
    private Driver delegate;
    private String delegateSchemeName;

    public IamAuthJdbcDriverWrapper() {
        this(null, null, null, null, true);
    }

    public IamAuthJdbcDriverWrapper(String wrapperSchemeName, String delegateSchemeName, Integer defaultPort, String driverClassName, boolean acceptDelegateUrls) {
        this(wrapperSchemeName, delegateSchemeName, DEFAULT_PASSWORD_PROPERTY, DEFAULT_USER_PROPERTY, defaultPort, driverClassName, acceptDelegateUrls);
    }

    public IamAuthJdbcDriverWrapper(String wrapperSchemeName, String delegateSchemeName, String passwordProperty, String userProperty, Integer defaultPort, String driverClassName, boolean acceptDelegateUrls) {
        this.wrapperSchemeName = wrapperSchemeName;
        this.delegateSchemeName = delegateSchemeName;
        this.passwordProperty = passwordProperty;
        this.userProperty = userProperty;
        this.defaultPort = defaultPort;
        this.driverClassName = driverClassName;
        this.acceptDelegateUrls = acceptDelegateUrls;
    }

    protected static void initialiseDriverRegistration(IamAuthJdbcDriverWrapper driver) {
        try {
            LOGGER.fine(() -> "Registering IAM driver wrapper with properties:  wrapperSchemeName=" + driver.wrapperSchemeName + ", delegateSchemeName=" + driver.delegateSchemeName + ", defaultPort=" + driver.defaultPort + ", driverClassName=" + driver.driverClassName);
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error registering IAM driver wrapper", e);
            throw new ExceptionInInitializerError(e);
        }
    }

    private static Map<String, String> mergeProperties(Properties properties, Map<String, String> uriProperties) {
        HashMap<String, String> merged = new HashMap<String, String>();
        properties.stringPropertyNames().forEach(sp -> merged.put((String)sp, properties.getProperty((String)sp)));
        merged.putAll(uriProperties);
        return merged;
    }

    public static Map<String, String> parseQueryString(URI uri) {
        String[] pairs;
        if (uri == null || uri.getQuery() == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            try {
                queryParams.put(URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()), URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return queryParams;
    }

    private static Driver resolveDriver(String driverClassName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> driverClass = Class.forName(driverClassName);
        return (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        this.assertUrlNotNull(url);
        URI parsed = this.parseJdbcUrl(url);
        this.attemptResolveDelegateDriverDetails(parsed);
        if (this.isWrapperScheme(parsed)) {
            return true;
        }
        if (this.delegate != null && this.acceptDelegateUrls) {
            return this.delegate.acceptsURL(url);
        }
        return false;
    }

    private void attemptResolveDelegateDriverDetails(URI uri) {
        if (uri != null) {
            Map<String, String> uriProperties = IamAuthJdbcDriverWrapper.parseQueryString(uri);
            this.attemptDelegateDriverResolve(uriProperties);
            this.resolveDelegateSchemeName(uriProperties);
        }
    }

    private boolean isWrapperScheme(URI parsed) {
        return this.wrapperSchemeName != null && parsed != null && this.wrapperSchemeName.equals(parsed.getScheme());
    }

    private String replaceScheme(String url) {
        return url.replaceFirst(Pattern.quote(this.wrapperSchemeName), this.delegateSchemeName);
    }

    private void assertUrlNotNull(String url) throws SQLException {
        if (url == null) {
            throw new SQLException(new NullPointerException());
        }
    }

    private URI parseJdbcUrl(String url) {
        if (url == null || !url.startsWith(JDBC_URL_PREFIX)) {
            return null;
        }
        String substring = url.substring(JDBC_URL_PREFIX.length());
        return URI.create(substring);
    }

    @Override
    public Connection connect(String url, Properties connectionProperties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        URI parsed = this.parseJdbcUrl(url);
        Map<String, String> properties = IamAuthJdbcDriverWrapper.mergeProperties(connectionProperties, IamAuthJdbcDriverWrapper.parseQueryString(parsed));
        this.resolveDelegateDriver(properties);
        this.resolveDelegateSchemeName(properties);
        try {
            String host = this.host(parsed);
            int port = this.port(parsed);
            String rdsIamAuthToken = this.generateRdsIamAuthToken(host, port, properties);
            connectionProperties.setProperty(this.passwordProperty, rdsIamAuthToken);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "RDS IAM auth token generation failed, attempting to call delegate driver without IAM token", e);
        }
        String connectUrl = this.isWrapperScheme(parsed) ? this.replaceScheme(url) : url;
        return this.delegate.connect(connectUrl, connectionProperties);
    }

    private void resolveDelegateSchemeName(Map<String, String> properties) {
        if (this.delegateSchemeName != null) {
            return;
        }
        this.delegateSchemeName = properties.get(DELEGATE_DRIVER_SCHEME_NAME_PROPERTY);
    }

    private void attemptDelegateDriverResolve(Map<String, String> properties) {
        try {
            this.resolveDelegateDriver(properties);
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, "Attempt to resolve delegate driver failed", e);
        }
    }

    private void resolveDelegateDriver(Map<String, String> properties) throws SQLException {
        if (this.delegate != null) {
            return;
        }
        String driverToResolve = properties.getOrDefault(DELEGATE_DRIVER_CLASS_PROPERTY, this.driverClassName);
        if (driverToResolve == null) {
            throw new SQLException("No delegate JDBC driver configured");
        }
        try {
            this.delegate = IamAuthJdbcDriverWrapper.resolveDriver(driverToResolve);
        }
        catch (Exception e) {
            throw new SQLException("Unable to load delegate JDBC driver", e);
        }
    }

    private String host(URI uri) throws SQLException {
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        throw new SQLException("No database host specified. IAM Auth requires that a host be specified in the JDBC URL.");
    }

    private int port(URI uri) throws SQLException {
        if (uri.getPort() != -1) {
            return uri.getPort();
        }
        if (this.defaultPort != null) {
            return this.defaultPort;
        }
        throw new SQLException("No database port specified. IAM Auth requires that either a default port be pre-configured or a port is specified in the JDBC URL.");
    }

    public String generateRdsIamAuthToken(String host, int port, Map<String, String> properties) {
        String usernameProperty = properties.get(this.userProperty);
        String regionProperty = properties.get(AWS_REGION_PROPERTY);
        String awsProfile = properties.get(AWS_PROFILE_PROPERTY);
        String region = this.resolveRegion(regionProperty, awsProfile);
        RdsIamAuthTokenGenerator generator = RdsIamAuthTokenGenerator.builder().credentials(this.resolveCredentialProvider(properties)).region(region).build();
        LOGGER.fine("Generating RDS IAM auth token for: Host=" + host + ", Port=" + port + ", Username=" + usernameProperty);
        return generator.getAuthToken(new GetIamAuthTokenRequest(host, port, usernameProperty));
    }

    private String resolveRegion(String regionProperty, String awsProfileProperty) {
        AwsProfileRegionProvider awsProfileRegionProvider;
        if (regionProperty != null) {
            return regionProperty;
        }
        if (awsProfileProperty != null && (awsProfileRegionProvider = new AwsProfileRegionProvider(awsProfileProperty)).getRegion() != null) {
            return awsProfileRegionProvider.getRegion();
        }
        return this.defaultAwsRegionProviderChain.getRegion();
    }

    private AWSCredentialsProvider resolveCredentialProvider(Map<String, String> properties) {
        String awsProfile = properties.get(AWS_PROFILE_PROPERTY);
        String awsAccessKey = properties.get(AWS_ACCESS_KEY_ID_PROPERTY);
        String awsSecretKey = properties.get(AWS_SECRET_ACCESS_KEY_PROPERTY);
        AWSCredentialsProvider baseCredentialProvider = awsAccessKey != null && awsSecretKey != null ? new AWSStaticCredentialsProvider(new BasicAWSCredentials(awsAccessKey, awsSecretKey)) : (awsProfile != null ? new ProfileCredentialsProvider(awsProfile) : this.defaultAWSCredentialsProviderChain);
        String assumedRole = properties.get(AWS_STS_CREDENTIAL_ROLE_ARN_PROPERTY);
        String externalId = properties.get(AWS_STS_CREDENTIAL_EXTERNAL_ID_PROPERTY);
        String roleSessionNameProperty = properties.get(AWS_STS_CREDENTIAL_SESSION_NAME_PROPERTY);
        if (assumedRole != null) {
            String roleSessionName = roleSessionNameProperty == null ? "IAM_RDS_JDBC_DRIVER_WRAPPER" + UUID.randomUUID().toString() : roleSessionNameProperty;
            RoleInfo roleInfo = new RoleInfo().withRoleArn(assumedRole).withLongLivedCredentialsProvider(baseCredentialProvider).withExternalId(externalId).withRoleSessionName(roleSessionName);
            LOGGER.fine(() -> "Assuming role with ARN: " + assumedRole + ", and Session Name: " + roleSessionName);
            return new STSProfileCredentialsServiceProvider(roleInfo);
        }
        return baseCredentialProvider;
    }

    @Override
    public int getMajorVersion() {
        if (this.delegate == null) {
            this.logDelegateNotInitialised("getMajorValue");
            return -1;
        }
        return this.delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        if (this.delegate == null) {
            this.logDelegateNotInitialised("getMinorVersion");
            return -1;
        }
        return this.delegate.getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        if (this.delegate == null) {
            this.logDelegateNotInitialised("getParentLogger");
            throw new SQLFeatureNotSupportedException("Delegate driver not initialised");
        }
        return this.delegate.getParentLogger();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        this.assertUrlNotNull(url);
        this.attemptResolveDelegateDriverDetails(this.parseJdbcUrl(url));
        return this.delegate.getPropertyInfo(url, properties);
    }

    @Override
    public boolean jdbcCompliant() {
        if (this.delegate == null) {
            this.logDelegateNotInitialised("jdbcCompliant");
            return false;
        }
        return this.delegate.jdbcCompliant();
    }

    private void logDelegateNotInitialised(String method) {
        LOGGER.warning("Method " + method + " called, but delegate driver not initialised, returning bogus value");
    }

    static {
        IamAuthJdbcDriverWrapper.initialiseDriverRegistration(new IamAuthJdbcDriverWrapper());
    }
}

