/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.BacktrackDBClusterRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class BacktrackDBClusterRequestMarshaller
implements Marshaller<Request<BacktrackDBClusterRequest>, BacktrackDBClusterRequest> {
    @Override
    public Request<BacktrackDBClusterRequest> marshall(BacktrackDBClusterRequest backtrackDBClusterRequest) {
        if (backtrackDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BacktrackDBClusterRequest> request = new DefaultRequest<BacktrackDBClusterRequest>(backtrackDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "BacktrackDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (backtrackDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(backtrackDBClusterRequest.getDBClusterIdentifier()));
        }
        if (backtrackDBClusterRequest.getBacktrackTo() != null) {
            request.addParameter("BacktrackTo", StringUtils.fromDate(backtrackDBClusterRequest.getBacktrackTo()));
        }
        if (backtrackDBClusterRequest.getForce() != null) {
            request.addParameter("Force", StringUtils.fromBoolean(backtrackDBClusterRequest.getForce()));
        }
        if (backtrackDBClusterRequest.getUseEarliestTimeOnPointInTimeUnavailable() != null) {
            request.addParameter("UseEarliestTimeOnPointInTimeUnavailable", StringUtils.fromBoolean(backtrackDBClusterRequest.getUseEarliestTimeOnPointInTimeUnavailable()));
        }
        return request;
    }
}

