/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.AddTagsToResourceRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Tag;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class AddTagsToResourceRequestMarshaller
implements Marshaller<Request<AddTagsToResourceRequest>, AddTagsToResourceRequest> {
    @Override
    public Request<AddTagsToResourceRequest> marshall(AddTagsToResourceRequest addTagsToResourceRequest) {
        if (addTagsToResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddTagsToResourceRequest> request = new DefaultRequest<AddTagsToResourceRequest>(addTagsToResourceRequest, "AmazonRDS");
        request.addParameter("Action", "AddTagsToResource");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addTagsToResourceRequest.getResourceName() != null) {
            request.addParameter("ResourceName", StringUtils.fromString(addTagsToResourceRequest.getResourceName()));
        }
        if (!addTagsToResourceRequest.getTags().isEmpty() || !((SdkInternalList)addTagsToResourceRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)addTagsToResourceRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

