/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.http;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.annotation.SdkInternalApi;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpResponse;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.http.ErrorCodeParser;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.protocol.json.JsonContent;
import java.util.Arrays;

@SdkInternalApi
public class CompositeErrorCodeParser
implements ErrorCodeParser {
    private final Iterable<ErrorCodeParser> parsers;

    public CompositeErrorCodeParser(Iterable<ErrorCodeParser> parsers) {
        this.parsers = parsers;
    }

    public CompositeErrorCodeParser(ErrorCodeParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public String parseErrorCode(HttpResponse response, JsonContent jsonContent) {
        for (ErrorCodeParser parser : this.parsers) {
            String errorCode = parser.parseErrorCode(response, jsonContent);
            if (errorCode == null) continue;
            return errorCode;
        }
        return null;
    }
}

