/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.AmazonClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SDKGlobalConfiguration;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.AWSCredentials;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.AWSCredentialsProvider;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.InstanceMetadataServiceCredentialsFetcher;
import io.magj.iamjdbcdriver.repackaged.org.apache.commons.logging.Log;
import io.magj.iamjdbcdriver.repackaged.org.apache.commons.logging.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider,
Closeable {
    private static final Log LOG = LogFactory.getLog(InstanceProfileCredentialsProvider.class);
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    private static final InstanceProfileCredentialsProvider INSTANCE = new InstanceProfileCredentialsProvider();
    private final InstanceMetadataServiceCredentialsFetcher credentialsFetcher = new InstanceMetadataServiceCredentialsFetcher();
    private volatile ScheduledExecutorService executor;
    private volatile boolean shouldRefresh = false;

    @Deprecated
    public InstanceProfileCredentialsProvider() {
        this(false);
    }

    public InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync) {
        this(refreshCredentialsAsync, true);
    }

    public static InstanceProfileCredentialsProvider createAsyncRefreshingProvider(boolean eagerlyRefreshCredentialsAsync) {
        return new InstanceProfileCredentialsProvider(true, eagerlyRefreshCredentialsAsync);
    }

    private InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync, boolean eagerlyRefreshCredentialsAsync) {
        if (!SDKGlobalConfiguration.isEc2MetadataDisabled() && refreshCredentialsAsync) {
            this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("instance-profile-credentials-refresh");
                    t.setDaemon(true);
                    return t;
                }
            });
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (InstanceProfileCredentialsProvider.this.shouldRefresh) {
                            InstanceProfileCredentialsProvider.this.credentialsFetcher.getCredentials();
                        }
                    }
                    catch (AmazonClientException ace) {
                        InstanceProfileCredentialsProvider.this.handleError(ace);
                    }
                    catch (RuntimeException re) {
                        InstanceProfileCredentialsProvider.this.handleError(re);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    public static InstanceProfileCredentialsProvider getInstance() {
        return INSTANCE;
    }

    private void handleError(Throwable t) {
        this.refresh();
        LOG.error(t.getMessage(), t);
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        if (SDKGlobalConfiguration.isEc2MetadataDisabled()) {
            throw new AmazonClientException("AWS_EC2_METADATA_DISABLED is set to true, not loading credentials from EC2 Instance Metadata service");
        }
        AWSCredentials creds = this.credentialsFetcher.getCredentials();
        this.shouldRefresh = true;
        return creds;
    }

    @Override
    public void refresh() {
        if (this.credentialsFetcher != null) {
            this.credentialsFetcher.refresh();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }
}

