/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.fasterxml.jackson.databind.deser.std;

import io.magj.iamjdbcdriver.repackaged.com.fasterxml.jackson.databind.JsonDeserializer;
import io.magj.iamjdbcdriver.repackaged.com.fasterxml.jackson.databind.deser.std.AtomicBooleanDeserializer;
import io.magj.iamjdbcdriver.repackaged.com.fasterxml.jackson.databind.deser.std.ByteBufferDeserializer;
import io.magj.iamjdbcdriver.repackaged.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import io.magj.iamjdbcdriver.repackaged.com.fasterxml.jackson.databind.deser.std.StackTraceElementDeserializer;
import io.magj.iamjdbcdriver.repackaged.com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> rawType, String clsName) {
        if (_classNames.contains(clsName)) {
            FromStringDeserializer.Std d = FromStringDeserializer.findDeserializer(rawType);
            if (d != null) {
                return d;
            }
            if (rawType == UUID.class) {
                return new UUIDDeserializer();
            }
            if (rawType == StackTraceElement.class) {
                return new StackTraceElementDeserializer();
            }
            if (rawType == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (rawType == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
        }
        return null;
    }

    static {
        Class[] types;
        _classNames = new HashSet();
        for (Class clazz : types = new Class[]{UUID.class, AtomicBoolean.class, StackTraceElement.class, ByteBuffer.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

