/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.ScalingConfiguration;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ScalingConfigurationStaxUnmarshaller
implements Unmarshaller<ScalingConfiguration, StaxUnmarshallerContext> {
    private static ScalingConfigurationStaxUnmarshaller instance;

    @Override
    public ScalingConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScalingConfiguration scalingConfiguration = new ScalingConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return scalingConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MinCapacity", targetDepth)) {
                    scalingConfiguration.setMinCapacity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxCapacity", targetDepth)) {
                    scalingConfiguration.setMaxCapacity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoPause", targetDepth)) {
                    scalingConfiguration.setAutoPause(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecondsUntilAutoPause", targetDepth)) {
                    scalingConfiguration.setSecondsUntilAutoPause(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TimeoutAction", targetDepth)) continue;
                scalingConfiguration.setTimeoutAction(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return scalingConfiguration;
    }

    public static ScalingConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

