/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeDBClusterBacktracksRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Filter;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class DescribeDBClusterBacktracksRequestMarshaller
implements Marshaller<Request<DescribeDBClusterBacktracksRequest>, DescribeDBClusterBacktracksRequest> {
    @Override
    public Request<DescribeDBClusterBacktracksRequest> marshall(DescribeDBClusterBacktracksRequest describeDBClusterBacktracksRequest) {
        if (describeDBClusterBacktracksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDBClusterBacktracksRequest> request = new DefaultRequest<DescribeDBClusterBacktracksRequest>(describeDBClusterBacktracksRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBClusterBacktracks");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterBacktracksRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(describeDBClusterBacktracksRequest.getDBClusterIdentifier()));
        }
        if (describeDBClusterBacktracksRequest.getBacktrackIdentifier() != null) {
            request.addParameter("BacktrackIdentifier", StringUtils.fromString(describeDBClusterBacktracksRequest.getBacktrackIdentifier()));
        }
        if (!describeDBClusterBacktracksRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBClusterBacktracksRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBClusterBacktracksRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBClusterBacktracksRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeDBClusterBacktracksRequest.getMaxRecords()));
        }
        if (describeDBClusterBacktracksRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeDBClusterBacktracksRequest.getMarker()));
        }
        return request;
    }
}

