/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Tag;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class CreateDBSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateDBSubnetGroupRequest>, CreateDBSubnetGroupRequest> {
    @Override
    public Request<CreateDBSubnetGroupRequest> marshall(CreateDBSubnetGroupRequest createDBSubnetGroupRequest) {
        if (createDBSubnetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDBSubnetGroupRequest> request = new DefaultRequest<CreateDBSubnetGroupRequest>(createDBSubnetGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBSubnetGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBSubnetGroupRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString(createDBSubnetGroupRequest.getDBSubnetGroupName()));
        }
        if (createDBSubnetGroupRequest.getDBSubnetGroupDescription() != null) {
            request.addParameter("DBSubnetGroupDescription", StringUtils.fromString(createDBSubnetGroupRequest.getDBSubnetGroupDescription()));
        }
        if (!createDBSubnetGroupRequest.getSubnetIds().isEmpty() || !((SdkInternalList)createDBSubnetGroupRequest.getSubnetIds()).isAutoConstruct()) {
            SdkInternalList subnetIdsList = (SdkInternalList)createDBSubnetGroupRequest.getSubnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString(subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (!createDBSubnetGroupRequest.getTags().isEmpty() || !((SdkInternalList)createDBSubnetGroupRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBSubnetGroupRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

