/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import com.amazonaws.auth.profile.internal.securitytoken.STSProfileCredentialsServiceProvider;
import com.amazonaws.regions.AwsProfileRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.services.rds.auth.GetIamAuthTokenRequest;
import com.amazonaws.services.rds.auth.RdsIamAuthTokenGenerator;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class IamAuthJdbcDriverWrapper
implements Driver {
    public static final String DELEGATE_DRIVER_CLASS_PROPERTY = "delegateJdbcDriverClass";
    public static final String DELEGATE_DRIVER_SCHEME_NAME_PROPERTY = "delegateJdbcDriverSchemeName";
    public static final String AWS_REGION_PROPERTY = "awsRegion";
    public static final String AWS_PROFILE_PROPERTY = "awsProfile";
    public static final String AWS_STS_CREDENTIAL_ROLE_ARN_PROPERTY = "awsStsCredentialProviderRoleArn";
    public static final String AWS_STS_CREDENTIAL_SESSION_NAME_PROPERTY = "awsStsCredentialProviderSessionName";
    public static final String AWS_STS_CREDENTIAL_EXTERNAL_ID_PROPERTY = "awsStsCredentialProviderExternalId";
    public static final String AWS_ACCESS_KEY_ID_PROPERTY = "awsAccessKeyId";
    public static final String AWS_SECRET_ACCESS_KEY_PROPERTY = "awsSecretAccessKey";
    public static final String DEFAULT_PASSWORD_PROPERTY = "password";
    public static final String DEFAULT_USER_PROPERTY = "user";
    private static final String JDBC_URL_PREFIX = "jdbc:";
    private final DefaultAwsRegionProviderChain defaultAwsRegionProviderChain = new DefaultAwsRegionProviderChain();
    private final DefaultAWSCredentialsProviderChain defaultAWSCredentialsProviderChain = DefaultAWSCredentialsProviderChain.getInstance();
    private final String wrapperSchemeName;
    private final String passwordProperty;
    private final String userProperty;
    private final Integer defaultPort;
    private final String driverClassName;
    private Driver delegate;
    private String delegateSchemeName;

    public IamAuthJdbcDriverWrapper() {
        this(null, null, null, null);
    }

    public IamAuthJdbcDriverWrapper(String wrapperSchemeName, String delegateSchemeName, Integer defaultPort, String driverClassName) {
        this(wrapperSchemeName, delegateSchemeName, DEFAULT_PASSWORD_PROPERTY, DEFAULT_USER_PROPERTY, defaultPort, driverClassName);
    }

    public IamAuthJdbcDriverWrapper(String wrapperSchemeName, String delegateSchemeName, String passwordProperty, String userProperty, Integer defaultPort, String driverClassName) {
        this.wrapperSchemeName = wrapperSchemeName;
        this.delegateSchemeName = delegateSchemeName;
        this.passwordProperty = passwordProperty;
        this.userProperty = userProperty;
        this.defaultPort = defaultPort;
        this.driverClassName = driverClassName;
    }

    protected static void initialiseDriverRegistration(IamAuthJdbcDriverWrapper driver) {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static String getProperty(String propertyName, Properties connectionProperties, Map<String, String> uriProperties) {
        String property = uriProperties.get(propertyName);
        if (property == null) {
            property = connectionProperties.getProperty(propertyName);
        }
        return property;
    }

    public static Map<String, String> parseQueryString(URI uri) {
        String[] pairs;
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            try {
                queryParams.put(URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()), URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return queryParams;
    }

    private static Driver resolveDriver(String driverClassName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> driverClass = Class.forName(driverClassName);
        return (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        URI parsed = this.parseJdbcUrl(url);
        if (this.isWrapperScheme(parsed)) {
            boolean isWrapperScheme = false;
            boolean isDelegateScheme = false;
            if (this.wrapperSchemeName != null) {
                isWrapperScheme = this.wrapperSchemeName.equals(parsed.getScheme());
            }
            if (this.delegateSchemeName != null) {
                isDelegateScheme = this.delegateSchemeName.equals(parsed.getScheme());
            }
            return isWrapperScheme || isDelegateScheme;
        }
        if (this.delegate != null) {
            return this.delegate.acceptsURL(url);
        }
        return true;
    }

    private boolean isWrapperScheme(URI parsed) {
        return this.wrapperSchemeName != null && parsed != null && this.wrapperSchemeName.equals(parsed.getScheme());
    }

    private String replaceScheme(String url) {
        return url.replaceFirst(Pattern.quote(this.wrapperSchemeName), this.delegateSchemeName);
    }

    private URI parseJdbcUrl(String url) {
        if (url == null || !url.startsWith(JDBC_URL_PREFIX)) {
            return null;
        }
        String substring = url.substring(JDBC_URL_PREFIX.length());
        return URI.create(substring);
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        URI parsed = this.parseJdbcUrl(url);
        if (parsed == null) {
            throw new SQLException("IAM auth wrapper cannot parse URL: " + url);
        }
        String host = this.host(parsed);
        int port = this.port(parsed);
        Map<String, String> uriProperties = IamAuthJdbcDriverWrapper.parseQueryString(parsed);
        this.resolveDelegateDriver(properties, uriProperties);
        this.resolveDelegateSchemeName(properties, uriProperties);
        String rdsIamAuthToken = this.generateRdsIamAuthToken(host, port, properties, uriProperties);
        properties.setProperty(this.passwordProperty, rdsIamAuthToken);
        String connectUrl = this.isWrapperScheme(parsed) ? this.replaceScheme(url) : url;
        return this.delegate.connect(connectUrl, properties);
    }

    private void resolveDelegateSchemeName(Properties connectionProperties, Map<String, String> uriProperties) {
        if (this.delegateSchemeName != null) {
            return;
        }
        this.delegateSchemeName = IamAuthJdbcDriverWrapper.getProperty(DELEGATE_DRIVER_SCHEME_NAME_PROPERTY, connectionProperties, uriProperties);
    }

    private void resolveDelegateDriver(Properties connectionProperties, Map<String, String> uriProperties) {
        String driverToResolve;
        if (this.delegate != null) {
            return;
        }
        String driverClassNameProperty = IamAuthJdbcDriverWrapper.getProperty(DELEGATE_DRIVER_CLASS_PROPERTY, connectionProperties, uriProperties);
        String string = driverToResolve = driverClassNameProperty != null ? driverClassNameProperty : this.driverClassName;
        if (driverToResolve == null) {
            throw new IllegalStateException("No delegate JDBC driver configured");
        }
        try {
            this.delegate = IamAuthJdbcDriverWrapper.resolveDriver(driverToResolve);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load delegate JDBC driver", e);
        }
    }

    private String host(URI uri) throws SQLException {
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        throw new SQLException("No database host specified. IAM Auth requires that a host be specified in the JDBC URL.");
    }

    private int port(URI uri) throws SQLException {
        if (uri.getPort() != -1) {
            return uri.getPort();
        }
        if (this.defaultPort != null) {
            return this.defaultPort;
        }
        throw new SQLException("No database port specified. IAM Auth requires that a port be specified in the JDBC URL.");
    }

    public String generateRdsIamAuthToken(String host, int port, Properties connectionProperties, Map<String, String> uriProperties) {
        String usernameProperty = IamAuthJdbcDriverWrapper.getProperty(this.userProperty, connectionProperties, uriProperties);
        String regionProperty = IamAuthJdbcDriverWrapper.getProperty(AWS_REGION_PROPERTY, connectionProperties, uriProperties);
        String awsProfile = IamAuthJdbcDriverWrapper.getProperty(AWS_PROFILE_PROPERTY, connectionProperties, uriProperties);
        String region = this.resolveRegion(regionProperty, awsProfile);
        RdsIamAuthTokenGenerator generator = RdsIamAuthTokenGenerator.builder().credentials(this.resolveCredentialProvider(connectionProperties, uriProperties)).region(region).build();
        return generator.getAuthToken(new GetIamAuthTokenRequest(host, port, usernameProperty));
    }

    private String resolveRegion(String regionProperty, String awsProfileProperty) {
        AwsProfileRegionProvider awsProfileRegionProvider;
        if (regionProperty != null) {
            return regionProperty;
        }
        if (awsProfileProperty != null && (awsProfileRegionProvider = new AwsProfileRegionProvider(awsProfileProperty)).getRegion() != null) {
            return awsProfileRegionProvider.getRegion();
        }
        return this.defaultAwsRegionProviderChain.getRegion();
    }

    private AWSCredentialsProvider resolveCredentialProvider(Properties connectionProperties, Map<String, String> uriProperties) {
        String awsProfile = IamAuthJdbcDriverWrapper.getProperty(AWS_PROFILE_PROPERTY, connectionProperties, uriProperties);
        String awsAccessKey = IamAuthJdbcDriverWrapper.getProperty(AWS_ACCESS_KEY_ID_PROPERTY, connectionProperties, uriProperties);
        String awsSecretKey = IamAuthJdbcDriverWrapper.getProperty(AWS_SECRET_ACCESS_KEY_PROPERTY, connectionProperties, uriProperties);
        Object baseCredentialProvider = awsAccessKey != null && awsSecretKey != null ? new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey)) : (awsProfile != null ? new ProfileCredentialsProvider(awsProfile) : this.defaultAWSCredentialsProviderChain);
        String assumedRole = IamAuthJdbcDriverWrapper.getProperty(AWS_STS_CREDENTIAL_ROLE_ARN_PROPERTY, connectionProperties, uriProperties);
        String externalId = IamAuthJdbcDriverWrapper.getProperty(AWS_STS_CREDENTIAL_EXTERNAL_ID_PROPERTY, connectionProperties, uriProperties);
        String roleSessionNameProperty = IamAuthJdbcDriverWrapper.getProperty(AWS_STS_CREDENTIAL_SESSION_NAME_PROPERTY, connectionProperties, uriProperties);
        if (assumedRole != null) {
            String roleSessionName = roleSessionNameProperty == null ? "IAM_RDS_JDBC_DRIVER_WRAPPER" + UUID.randomUUID().toString() : roleSessionNameProperty;
            RoleInfo roleInfo = new RoleInfo().withRoleArn(assumedRole).withLongLivedCredentialsProvider((AWSCredentialsProvider)baseCredentialProvider).withExternalId(externalId).withRoleSessionName(roleSessionName);
            return new STSProfileCredentialsServiceProvider(roleInfo);
        }
        return baseCredentialProvider;
    }

    @Override
    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        return this.delegate.getPropertyInfo(url, properties);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.delegate.jdbcCompliant();
    }

    static {
        IamAuthJdbcDriverWrapper.initialiseDriverRegistration(new IamAuthJdbcDriverWrapper());
    }
}

