/*
 * Decompiled with CFR 0.152.
 */
package repackaged.org.apache.http.protocol;

import java.io.IOException;
import repackaged.org.apache.http.HttpException;
import repackaged.org.apache.http.HttpResponse;
import repackaged.org.apache.http.HttpResponseInterceptor;
import repackaged.org.apache.http.annotation.Contract;
import repackaged.org.apache.http.annotation.ThreadingBehavior;
import repackaged.org.apache.http.protocol.HttpContext;
import repackaged.org.apache.http.protocol.HttpDateGenerator;
import repackaged.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

