/*
 * Decompiled with CFR 0.152.
 */
package repackaged.org.apache.http.protocol;

import java.io.IOException;
import repackaged.org.apache.http.HttpEntity;
import repackaged.org.apache.http.HttpEntityEnclosingRequest;
import repackaged.org.apache.http.HttpException;
import repackaged.org.apache.http.HttpRequest;
import repackaged.org.apache.http.HttpRequestInterceptor;
import repackaged.org.apache.http.HttpVersion;
import repackaged.org.apache.http.ProtocolVersion;
import repackaged.org.apache.http.annotation.Contract;
import repackaged.org.apache.http.annotation.ThreadingBehavior;
import repackaged.org.apache.http.protocol.HttpContext;
import repackaged.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

