/*
 * Decompiled with CFR 0.152.
 */
package repackaged.org.apache.http.protocol;

import java.io.IOException;
import repackaged.org.apache.http.HttpEntityEnclosingRequest;
import repackaged.org.apache.http.HttpException;
import repackaged.org.apache.http.HttpRequest;
import repackaged.org.apache.http.HttpRequestInterceptor;
import repackaged.org.apache.http.annotation.Contract;
import repackaged.org.apache.http.annotation.ThreadingBehavior;
import repackaged.org.apache.http.protocol.HttpContext;
import repackaged.org.apache.http.protocol.HttpDateGenerator;
import repackaged.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

