/*
 * Decompiled with CFR 0.152.
 */
package repackaged.org.apache.http.protocol;

import java.io.IOException;
import repackaged.org.apache.http.HttpException;
import repackaged.org.apache.http.HttpRequest;
import repackaged.org.apache.http.HttpRequestInterceptor;
import repackaged.org.apache.http.annotation.Contract;
import repackaged.org.apache.http.annotation.ThreadingBehavior;
import repackaged.org.apache.http.protocol.HttpContext;
import repackaged.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

