/*
 * Decompiled with CFR 0.152.
 */
package repackaged.org.apache.http.client.protocol;

import java.io.IOException;
import repackaged.org.apache.http.HttpEntity;
import repackaged.org.apache.http.HttpEntityEnclosingRequest;
import repackaged.org.apache.http.HttpException;
import repackaged.org.apache.http.HttpRequest;
import repackaged.org.apache.http.HttpRequestInterceptor;
import repackaged.org.apache.http.HttpVersion;
import repackaged.org.apache.http.ProtocolVersion;
import repackaged.org.apache.http.annotation.Contract;
import repackaged.org.apache.http.annotation.ThreadingBehavior;
import repackaged.org.apache.http.client.config.RequestConfig;
import repackaged.org.apache.http.client.protocol.HttpClientContext;
import repackaged.org.apache.http.protocol.HttpContext;
import repackaged.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

