/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import repackaged.com.fasterxml.jackson.databind.introspect.Annotated;
import repackaged.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import repackaged.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import repackaged.com.fasterxml.jackson.databind.introspect.AnnotationMap;

public class VirtualAnnotatedMember
extends AnnotatedMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _declaringClass;
    protected final Class<?> _rawType;
    protected final String _name;

    public VirtualAnnotatedMember(AnnotatedClass contextClass, Class<?> declaringClass, String name, Class<?> rawType) {
        super(contextClass, null);
        this._declaringClass = declaringClass;
        this._rawType = rawType;
        this._name = name;
    }

    @Override
    public Annotated withAnnotations(AnnotationMap fallback) {
        return this;
    }

    @Override
    public Field getAnnotated() {
        return null;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return null;
    }

    @Override
    public Type getGenericType() {
        return this._rawType;
    }

    @Override
    public Class<?> getRawType() {
        return this._rawType;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._declaringClass;
    }

    @Override
    public Member getMember() {
        return null;
    }

    @Override
    public void setValue(Object pojo, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException("Can not set virtual property '" + this._name + "'");
    }

    @Override
    public Object getValue(Object pojo) throws IllegalArgumentException {
        throw new IllegalArgumentException("Can not get virtual property '" + this._name + "'");
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName();
    }

    public int getAnnotationCount() {
        return 0;
    }

    @Override
    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        VirtualAnnotatedMember other = (VirtualAnnotatedMember)o;
        return other._declaringClass == this._declaringClass && other._name.equals(this._name);
    }

    @Override
    public String toString() {
        return "[field " + this.getFullName() + "]";
    }
}

