/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import repackaged.com.amazonaws.services.rds.model.DoubleRange;
import repackaged.com.amazonaws.services.rds.model.Range;
import repackaged.com.amazonaws.services.rds.model.ValidStorageOptions;
import repackaged.com.amazonaws.services.rds.model.transform.DoubleRangeStaxUnmarshaller;
import repackaged.com.amazonaws.services.rds.model.transform.RangeStaxUnmarshaller;
import repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import repackaged.com.amazonaws.transform.Unmarshaller;

public class ValidStorageOptionsStaxUnmarshaller
implements Unmarshaller<ValidStorageOptions, StaxUnmarshallerContext> {
    private static ValidStorageOptionsStaxUnmarshaller instance;

    @Override
    public ValidStorageOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        ValidStorageOptions validStorageOptions = new ValidStorageOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return validStorageOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StorageType", targetDepth)) {
                    validStorageOptions.setStorageType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageSize", targetDepth)) {
                    validStorageOptions.withStorageSize(new ArrayList<Range>());
                    continue;
                }
                if (context.testExpression("StorageSize/Range", targetDepth)) {
                    validStorageOptions.withStorageSize(RangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProvisionedIops", targetDepth)) {
                    validStorageOptions.withProvisionedIops(new ArrayList<Range>());
                    continue;
                }
                if (context.testExpression("ProvisionedIops/Range", targetDepth)) {
                    validStorageOptions.withProvisionedIops(RangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IopsToStorageRatio", targetDepth)) {
                    validStorageOptions.withIopsToStorageRatio(new ArrayList<DoubleRange>());
                    continue;
                }
                if (context.testExpression("IopsToStorageRatio/DoubleRange", targetDepth)) {
                    validStorageOptions.withIopsToStorageRatio(DoubleRangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SupportsStorageAutoscaling", targetDepth)) continue;
                validStorageOptions.setSupportsStorageAutoscaling(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return validStorageOptions;
    }

    public static ValidStorageOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ValidStorageOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

