/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.services.rds.model.StopDBInstanceRequest;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class StopDBInstanceRequestMarshaller
implements Marshaller<Request<StopDBInstanceRequest>, StopDBInstanceRequest> {
    @Override
    public Request<StopDBInstanceRequest> marshall(StopDBInstanceRequest stopDBInstanceRequest) {
        if (stopDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopDBInstanceRequest> request = new DefaultRequest<StopDBInstanceRequest>(stopDBInstanceRequest, "AmazonRDS");
        request.addParameter("Action", "StopDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (stopDBInstanceRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString(stopDBInstanceRequest.getDBInstanceIdentifier()));
        }
        if (stopDBInstanceRequest.getDBSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString(stopDBInstanceRequest.getDBSnapshotIdentifier()));
        }
        return request;
    }
}

