/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.StartExportTaskRequest;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class StartExportTaskRequestMarshaller
implements Marshaller<Request<StartExportTaskRequest>, StartExportTaskRequest> {
    @Override
    public Request<StartExportTaskRequest> marshall(StartExportTaskRequest startExportTaskRequest) {
        if (startExportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartExportTaskRequest> request = new DefaultRequest<StartExportTaskRequest>(startExportTaskRequest, "AmazonRDS");
        request.addParameter("Action", "StartExportTask");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (startExportTaskRequest.getExportTaskIdentifier() != null) {
            request.addParameter("ExportTaskIdentifier", StringUtils.fromString(startExportTaskRequest.getExportTaskIdentifier()));
        }
        if (startExportTaskRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(startExportTaskRequest.getSourceArn()));
        }
        if (startExportTaskRequest.getS3BucketName() != null) {
            request.addParameter("S3BucketName", StringUtils.fromString(startExportTaskRequest.getS3BucketName()));
        }
        if (startExportTaskRequest.getIamRoleArn() != null) {
            request.addParameter("IamRoleArn", StringUtils.fromString(startExportTaskRequest.getIamRoleArn()));
        }
        if (startExportTaskRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(startExportTaskRequest.getKmsKeyId()));
        }
        if (startExportTaskRequest.getS3Prefix() != null) {
            request.addParameter("S3Prefix", StringUtils.fromString(startExportTaskRequest.getS3Prefix()));
        }
        if (!startExportTaskRequest.getExportOnly().isEmpty() || !((SdkInternalList)startExportTaskRequest.getExportOnly()).isAutoConstruct()) {
            SdkInternalList exportOnlyList = (SdkInternalList)startExportTaskRequest.getExportOnly();
            int exportOnlyListIndex = 1;
            for (String exportOnlyListValue : exportOnlyList) {
                if (exportOnlyListValue != null) {
                    request.addParameter("ExportOnly.member." + exportOnlyListIndex, StringUtils.fromString(exportOnlyListValue));
                }
                ++exportOnlyListIndex;
            }
        }
        return request;
    }
}

