/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.services.rds.model.StartActivityStreamRequest;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class StartActivityStreamRequestMarshaller
implements Marshaller<Request<StartActivityStreamRequest>, StartActivityStreamRequest> {
    @Override
    public Request<StartActivityStreamRequest> marshall(StartActivityStreamRequest startActivityStreamRequest) {
        if (startActivityStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartActivityStreamRequest> request = new DefaultRequest<StartActivityStreamRequest>(startActivityStreamRequest, "AmazonRDS");
        request.addParameter("Action", "StartActivityStream");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (startActivityStreamRequest.getResourceArn() != null) {
            request.addParameter("ResourceArn", StringUtils.fromString(startActivityStreamRequest.getResourceArn()));
        }
        if (startActivityStreamRequest.getMode() != null) {
            request.addParameter("Mode", StringUtils.fromString(startActivityStreamRequest.getMode()));
        }
        if (startActivityStreamRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(startActivityStreamRequest.getKmsKeyId()));
        }
        if (startActivityStreamRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(startActivityStreamRequest.getApplyImmediately()));
        }
        return request;
    }
}

