/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.RegisterDBProxyTargetsRequest;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class RegisterDBProxyTargetsRequestMarshaller
implements Marshaller<Request<RegisterDBProxyTargetsRequest>, RegisterDBProxyTargetsRequest> {
    @Override
    public Request<RegisterDBProxyTargetsRequest> marshall(RegisterDBProxyTargetsRequest registerDBProxyTargetsRequest) {
        if (registerDBProxyTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterDBProxyTargetsRequest> request = new DefaultRequest<RegisterDBProxyTargetsRequest>(registerDBProxyTargetsRequest, "AmazonRDS");
        request.addParameter("Action", "RegisterDBProxyTargets");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerDBProxyTargetsRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString(registerDBProxyTargetsRequest.getDBProxyName()));
        }
        if (registerDBProxyTargetsRequest.getTargetGroupName() != null) {
            request.addParameter("TargetGroupName", StringUtils.fromString(registerDBProxyTargetsRequest.getTargetGroupName()));
        }
        if (!registerDBProxyTargetsRequest.getDBInstanceIdentifiers().isEmpty() || !((SdkInternalList)registerDBProxyTargetsRequest.getDBInstanceIdentifiers()).isAutoConstruct()) {
            SdkInternalList dBInstanceIdentifiersList = (SdkInternalList)registerDBProxyTargetsRequest.getDBInstanceIdentifiers();
            int dBInstanceIdentifiersListIndex = 1;
            for (String dBInstanceIdentifiersListValue : dBInstanceIdentifiersList) {
                if (dBInstanceIdentifiersListValue != null) {
                    request.addParameter("DBInstanceIdentifiers.member." + dBInstanceIdentifiersListIndex, StringUtils.fromString(dBInstanceIdentifiersListValue));
                }
                ++dBInstanceIdentifiersListIndex;
            }
        }
        if (!registerDBProxyTargetsRequest.getDBClusterIdentifiers().isEmpty() || !((SdkInternalList)registerDBProxyTargetsRequest.getDBClusterIdentifiers()).isAutoConstruct()) {
            SdkInternalList dBClusterIdentifiersList = (SdkInternalList)registerDBProxyTargetsRequest.getDBClusterIdentifiers();
            int dBClusterIdentifiersListIndex = 1;
            for (String dBClusterIdentifiersListValue : dBClusterIdentifiersList) {
                if (dBClusterIdentifiersListValue != null) {
                    request.addParameter("DBClusterIdentifiers.member." + dBClusterIdentifiersListIndex, StringUtils.fromString(dBClusterIdentifiersListValue));
                }
                ++dBClusterIdentifiersListIndex;
            }
        }
        return request;
    }
}

