/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import javax.xml.stream.events.XMLEvent;
import repackaged.com.amazonaws.services.rds.model.Range;
import repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import repackaged.com.amazonaws.transform.Unmarshaller;

public class RangeStaxUnmarshaller
implements Unmarshaller<Range, StaxUnmarshallerContext> {
    private static RangeStaxUnmarshaller instance;

    @Override
    public Range unmarshall(StaxUnmarshallerContext context) throws Exception {
        Range range = new Range();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return range;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("From", targetDepth)) {
                    range.setFrom(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("To", targetDepth)) {
                    range.setTo(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Step", targetDepth)) continue;
                range.setStep(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return range;
    }

    public static RangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RangeStaxUnmarshaller();
        }
        return instance;
    }
}

