/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import repackaged.com.amazonaws.services.rds.model.Option;
import repackaged.com.amazonaws.services.rds.model.OptionGroup;
import repackaged.com.amazonaws.services.rds.model.transform.OptionStaxUnmarshaller;
import repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import repackaged.com.amazonaws.transform.Unmarshaller;

public class OptionGroupStaxUnmarshaller
implements Unmarshaller<OptionGroup, StaxUnmarshallerContext> {
    private static OptionGroupStaxUnmarshaller instance;

    @Override
    public OptionGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        OptionGroup optionGroup = new OptionGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return optionGroup;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("OptionGroupName", targetDepth)) {
                    optionGroup.setOptionGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OptionGroupDescription", targetDepth)) {
                    optionGroup.setOptionGroupDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineName", targetDepth)) {
                    optionGroup.setEngineName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MajorEngineVersion", targetDepth)) {
                    optionGroup.setMajorEngineVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Options", targetDepth)) {
                    optionGroup.withOptions(new ArrayList<Option>());
                    continue;
                }
                if (context.testExpression("Options/Option", targetDepth)) {
                    optionGroup.withOptions(OptionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowsVpcAndNonVpcInstanceMemberships", targetDepth)) {
                    optionGroup.setAllowsVpcAndNonVpcInstanceMemberships(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    optionGroup.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OptionGroupArn", targetDepth)) continue;
                optionGroup.setOptionGroupArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return optionGroup;
    }

    public static OptionGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OptionGroupStaxUnmarshaller();
        }
        return instance;
    }
}

