/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.ConnectionPoolConfiguration;
import repackaged.com.amazonaws.services.rds.model.ModifyDBProxyTargetGroupRequest;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class ModifyDBProxyTargetGroupRequestMarshaller
implements Marshaller<Request<ModifyDBProxyTargetGroupRequest>, ModifyDBProxyTargetGroupRequest> {
    @Override
    public Request<ModifyDBProxyTargetGroupRequest> marshall(ModifyDBProxyTargetGroupRequest modifyDBProxyTargetGroupRequest) {
        ConnectionPoolConfiguration connectionPoolConfig;
        if (modifyDBProxyTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyDBProxyTargetGroupRequest> request = new DefaultRequest<ModifyDBProxyTargetGroupRequest>(modifyDBProxyTargetGroupRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBProxyTargetGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBProxyTargetGroupRequest.getTargetGroupName() != null) {
            request.addParameter("TargetGroupName", StringUtils.fromString(modifyDBProxyTargetGroupRequest.getTargetGroupName()));
        }
        if (modifyDBProxyTargetGroupRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString(modifyDBProxyTargetGroupRequest.getDBProxyName()));
        }
        if ((connectionPoolConfig = modifyDBProxyTargetGroupRequest.getConnectionPoolConfig()) != null) {
            if (connectionPoolConfig.getMaxConnectionsPercent() != null) {
                request.addParameter("ConnectionPoolConfig.MaxConnectionsPercent", StringUtils.fromInteger(connectionPoolConfig.getMaxConnectionsPercent()));
            }
            if (connectionPoolConfig.getMaxIdleConnectionsPercent() != null) {
                request.addParameter("ConnectionPoolConfig.MaxIdleConnectionsPercent", StringUtils.fromInteger(connectionPoolConfig.getMaxIdleConnectionsPercent()));
            }
            if (connectionPoolConfig.getConnectionBorrowTimeout() != null) {
                request.addParameter("ConnectionPoolConfig.ConnectionBorrowTimeout", StringUtils.fromInteger(connectionPoolConfig.getConnectionBorrowTimeout()));
            }
            if (!connectionPoolConfig.getSessionPinningFilters().isEmpty() || !((SdkInternalList)connectionPoolConfig.getSessionPinningFilters()).isAutoConstruct()) {
                SdkInternalList sessionPinningFiltersList = (SdkInternalList)connectionPoolConfig.getSessionPinningFilters();
                int sessionPinningFiltersListIndex = 1;
                for (String sessionPinningFiltersListValue : sessionPinningFiltersList) {
                    if (sessionPinningFiltersListValue != null) {
                        request.addParameter("ConnectionPoolConfig.SessionPinningFilters.member." + sessionPinningFiltersListIndex, StringUtils.fromString(sessionPinningFiltersListValue));
                    }
                    ++sessionPinningFiltersListIndex;
                }
            }
            if (connectionPoolConfig.getInitQuery() != null) {
                request.addParameter("ConnectionPoolConfig.InitQuery", StringUtils.fromString(connectionPoolConfig.getInitQuery()));
            }
        }
        if (modifyDBProxyTargetGroupRequest.getNewName() != null) {
            request.addParameter("NewName", StringUtils.fromString(modifyDBProxyTargetGroupRequest.getNewName()));
        }
        return request;
    }
}

