/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.CloudwatchLogsExportConfiguration;
import repackaged.com.amazonaws.services.rds.model.ModifyDBClusterRequest;
import repackaged.com.amazonaws.services.rds.model.ScalingConfiguration;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class ModifyDBClusterRequestMarshaller
implements Marshaller<Request<ModifyDBClusterRequest>, ModifyDBClusterRequest> {
    @Override
    public Request<ModifyDBClusterRequest> marshall(ModifyDBClusterRequest modifyDBClusterRequest) {
        ScalingConfiguration scalingConfiguration;
        CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
        if (modifyDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyDBClusterRequest> request = new DefaultRequest<ModifyDBClusterRequest>(modifyDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(modifyDBClusterRequest.getDBClusterIdentifier()));
        }
        if (modifyDBClusterRequest.getNewDBClusterIdentifier() != null) {
            request.addParameter("NewDBClusterIdentifier", StringUtils.fromString(modifyDBClusterRequest.getNewDBClusterIdentifier()));
        }
        if (modifyDBClusterRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(modifyDBClusterRequest.getApplyImmediately()));
        }
        if (modifyDBClusterRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger(modifyDBClusterRequest.getBackupRetentionPeriod()));
        }
        if (modifyDBClusterRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString(modifyDBClusterRequest.getDBClusterParameterGroupName()));
        }
        if (!modifyDBClusterRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)modifyDBClusterRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)modifyDBClusterRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString(vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyDBClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(modifyDBClusterRequest.getPort()));
        }
        if (modifyDBClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString(modifyDBClusterRequest.getMasterUserPassword()));
        }
        if (modifyDBClusterRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(modifyDBClusterRequest.getOptionGroupName()));
        }
        if (modifyDBClusterRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString(modifyDBClusterRequest.getPreferredBackupWindow()));
        }
        if (modifyDBClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString(modifyDBClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyDBClusterRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean(modifyDBClusterRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (modifyDBClusterRequest.getBacktrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringUtils.fromLong(modifyDBClusterRequest.getBacktrackWindow()));
        }
        if ((cloudwatchLogsExportConfiguration = modifyDBClusterRequest.getCloudwatchLogsExportConfiguration()) != null) {
            if (!cloudwatchLogsExportConfiguration.getEnableLogTypes().isEmpty() || !((SdkInternalList)cloudwatchLogsExportConfiguration.getEnableLogTypes()).isAutoConstruct()) {
                SdkInternalList enableLogTypesList = (SdkInternalList)cloudwatchLogsExportConfiguration.getEnableLogTypes();
                int enableLogTypesListIndex = 1;
                for (String enableLogTypesListValue : enableLogTypesList) {
                    if (enableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.EnableLogTypes.member." + enableLogTypesListIndex, StringUtils.fromString(enableLogTypesListValue));
                    }
                    ++enableLogTypesListIndex;
                }
            }
            if (!cloudwatchLogsExportConfiguration.getDisableLogTypes().isEmpty() || !((SdkInternalList)cloudwatchLogsExportConfiguration.getDisableLogTypes()).isAutoConstruct()) {
                SdkInternalList disableLogTypesList = (SdkInternalList)cloudwatchLogsExportConfiguration.getDisableLogTypes();
                int disableLogTypesListIndex = 1;
                for (String disableLogTypesListValue : disableLogTypesList) {
                    if (disableLogTypesListValue != null) {
                        request.addParameter("CloudwatchLogsExportConfiguration.DisableLogTypes.member." + disableLogTypesListIndex, StringUtils.fromString(disableLogTypesListValue));
                    }
                    ++disableLogTypesListIndex;
                }
            }
        }
        if (modifyDBClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(modifyDBClusterRequest.getEngineVersion()));
        }
        if (modifyDBClusterRequest.getAllowMajorVersionUpgrade() != null) {
            request.addParameter("AllowMajorVersionUpgrade", StringUtils.fromBoolean(modifyDBClusterRequest.getAllowMajorVersionUpgrade()));
        }
        if (modifyDBClusterRequest.getDBInstanceParameterGroupName() != null) {
            request.addParameter("DBInstanceParameterGroupName", StringUtils.fromString(modifyDBClusterRequest.getDBInstanceParameterGroupName()));
        }
        if (modifyDBClusterRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString(modifyDBClusterRequest.getDomain()));
        }
        if (modifyDBClusterRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString(modifyDBClusterRequest.getDomainIAMRoleName()));
        }
        if ((scalingConfiguration = modifyDBClusterRequest.getScalingConfiguration()) != null) {
            if (scalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringUtils.fromInteger(scalingConfiguration.getMinCapacity()));
            }
            if (scalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringUtils.fromInteger(scalingConfiguration.getMaxCapacity()));
            }
            if (scalingConfiguration.getAutoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringUtils.fromBoolean(scalingConfiguration.getAutoPause()));
            }
            if (scalingConfiguration.getSecondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringUtils.fromInteger(scalingConfiguration.getSecondsUntilAutoPause()));
            }
            if (scalingConfiguration.getTimeoutAction() != null) {
                request.addParameter("ScalingConfiguration.TimeoutAction", StringUtils.fromString(scalingConfiguration.getTimeoutAction()));
            }
        }
        if (modifyDBClusterRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean(modifyDBClusterRequest.getDeletionProtection()));
        }
        if (modifyDBClusterRequest.getEnableHttpEndpoint() != null) {
            request.addParameter("EnableHttpEndpoint", StringUtils.fromBoolean(modifyDBClusterRequest.getEnableHttpEndpoint()));
        }
        if (modifyDBClusterRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean(modifyDBClusterRequest.getCopyTagsToSnapshot()));
        }
        return request;
    }
}

