/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import javax.xml.stream.events.XMLEvent;
import repackaged.com.amazonaws.services.rds.model.IPRange;
import repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import repackaged.com.amazonaws.transform.Unmarshaller;

public class IPRangeStaxUnmarshaller
implements Unmarshaller<IPRange, StaxUnmarshallerContext> {
    private static IPRangeStaxUnmarshaller instance;

    @Override
    public IPRange unmarshall(StaxUnmarshallerContext context) throws Exception {
        IPRange iPRange = new IPRange();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return iPRange;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    iPRange.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CIDRIP", targetDepth)) continue;
                iPRange.setCIDRIP(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return iPRange;
    }

    public static IPRangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IPRangeStaxUnmarshaller();
        }
        return instance;
    }
}

