/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import repackaged.com.amazonaws.services.rds.model.Filter;
import repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import repackaged.com.amazonaws.transform.Unmarshaller;

public class FilterStaxUnmarshaller
implements Unmarshaller<Filter, StaxUnmarshallerContext> {
    private static FilterStaxUnmarshaller instance;

    @Override
    public Filter unmarshall(StaxUnmarshallerContext context) throws Exception {
        Filter filter = new Filter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return filter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    filter.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Values", targetDepth)) {
                    filter.withValues(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Values/Value", targetDepth)) continue;
                filter.withValues(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return filter;
    }

    public static FilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FilterStaxUnmarshaller();
        }
        return instance;
    }
}

