/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import repackaged.com.amazonaws.services.rds.model.EngineDefaults;
import repackaged.com.amazonaws.services.rds.model.Parameter;
import repackaged.com.amazonaws.services.rds.model.transform.ParameterStaxUnmarshaller;
import repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import repackaged.com.amazonaws.transform.Unmarshaller;

public class EngineDefaultsStaxUnmarshaller
implements Unmarshaller<EngineDefaults, StaxUnmarshallerContext> {
    private static EngineDefaultsStaxUnmarshaller instance;

    @Override
    public EngineDefaults unmarshall(StaxUnmarshallerContext context) throws Exception {
        EngineDefaults engineDefaults = new EngineDefaults();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return engineDefaults;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                    engineDefaults.setDBParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Marker", targetDepth)) {
                    engineDefaults.setMarker(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    engineDefaults.withParameters(new ArrayList<Parameter>());
                    continue;
                }
                if (!context.testExpression("Parameters/Parameter", targetDepth)) continue;
                engineDefaults.withParameters(ParameterStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return engineDefaults;
    }

    public static EngineDefaultsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EngineDefaultsStaxUnmarshaller();
        }
        return instance;
    }
}

