/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.DescribeSourceRegionsRequest;
import repackaged.com.amazonaws.services.rds.model.Filter;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class DescribeSourceRegionsRequestMarshaller
implements Marshaller<Request<DescribeSourceRegionsRequest>, DescribeSourceRegionsRequest> {
    @Override
    public Request<DescribeSourceRegionsRequest> marshall(DescribeSourceRegionsRequest describeSourceRegionsRequest) {
        if (describeSourceRegionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSourceRegionsRequest> request = new DefaultRequest<DescribeSourceRegionsRequest>(describeSourceRegionsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeSourceRegions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSourceRegionsRequest.getRegionName() != null) {
            request.addParameter("RegionName", StringUtils.fromString(describeSourceRegionsRequest.getRegionName()));
        }
        if (describeSourceRegionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeSourceRegionsRequest.getMaxRecords()));
        }
        if (describeSourceRegionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeSourceRegionsRequest.getMarker()));
        }
        if (!describeSourceRegionsRequest.getFilters().isEmpty() || !((SdkInternalList)describeSourceRegionsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeSourceRegionsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

