/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import repackaged.com.amazonaws.services.rds.model.Filter;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class DescribeOrderableDBInstanceOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableDBInstanceOptionsRequest>, DescribeOrderableDBInstanceOptionsRequest> {
    @Override
    public Request<DescribeOrderableDBInstanceOptionsRequest> marshall(DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest) {
        if (describeOrderableDBInstanceOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeOrderableDBInstanceOptionsRequest> request = new DefaultRequest<DescribeOrderableDBInstanceOptionsRequest>(describeOrderableDBInstanceOptionsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeOrderableDBInstanceOptions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableDBInstanceOptionsRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString(describeOrderableDBInstanceOptionsRequest.getEngine()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(describeOrderableDBInstanceOptionsRequest.getEngineVersion()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString(describeOrderableDBInstanceOptionsRequest.getDBInstanceClass()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getLicenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString(describeOrderableDBInstanceOptionsRequest.getLicenseModel()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getVpc() != null) {
            request.addParameter("Vpc", StringUtils.fromBoolean(describeOrderableDBInstanceOptionsRequest.getVpc()));
        }
        if (!describeOrderableDBInstanceOptionsRequest.getFilters().isEmpty() || !((SdkInternalList)describeOrderableDBInstanceOptionsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeOrderableDBInstanceOptionsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOrderableDBInstanceOptionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeOrderableDBInstanceOptionsRequest.getMaxRecords()));
        }
        if (describeOrderableDBInstanceOptionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeOrderableDBInstanceOptionsRequest.getMarker()));
        }
        return request;
    }
}

