/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.DescribeGlobalClustersRequest;
import repackaged.com.amazonaws.services.rds.model.Filter;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class DescribeGlobalClustersRequestMarshaller
implements Marshaller<Request<DescribeGlobalClustersRequest>, DescribeGlobalClustersRequest> {
    @Override
    public Request<DescribeGlobalClustersRequest> marshall(DescribeGlobalClustersRequest describeGlobalClustersRequest) {
        if (describeGlobalClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeGlobalClustersRequest> request = new DefaultRequest<DescribeGlobalClustersRequest>(describeGlobalClustersRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeGlobalClusters");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeGlobalClustersRequest.getGlobalClusterIdentifier() != null) {
            request.addParameter("GlobalClusterIdentifier", StringUtils.fromString(describeGlobalClustersRequest.getGlobalClusterIdentifier()));
        }
        if (!describeGlobalClustersRequest.getFilters().isEmpty() || !((SdkInternalList)describeGlobalClustersRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeGlobalClustersRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeGlobalClustersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeGlobalClustersRequest.getMaxRecords()));
        }
        if (describeGlobalClustersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeGlobalClustersRequest.getMarker()));
        }
        return request;
    }
}

