/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.DescribeExportTasksRequest;
import repackaged.com.amazonaws.services.rds.model.Filter;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class DescribeExportTasksRequestMarshaller
implements Marshaller<Request<DescribeExportTasksRequest>, DescribeExportTasksRequest> {
    @Override
    public Request<DescribeExportTasksRequest> marshall(DescribeExportTasksRequest describeExportTasksRequest) {
        if (describeExportTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeExportTasksRequest> request = new DefaultRequest<DescribeExportTasksRequest>(describeExportTasksRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeExportTasks");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeExportTasksRequest.getExportTaskIdentifier() != null) {
            request.addParameter("ExportTaskIdentifier", StringUtils.fromString(describeExportTasksRequest.getExportTaskIdentifier()));
        }
        if (describeExportTasksRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(describeExportTasksRequest.getSourceArn()));
        }
        if (!describeExportTasksRequest.getFilters().isEmpty() || !((SdkInternalList)describeExportTasksRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeExportTasksRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeExportTasksRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeExportTasksRequest.getMarker()));
        }
        if (describeExportTasksRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromString(describeExportTasksRequest.getMaxRecords()));
        }
        return request;
    }
}

