/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest;
import repackaged.com.amazonaws.services.rds.model.Filter;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class DescribeEngineDefaultParametersRequestMarshaller
implements Marshaller<Request<DescribeEngineDefaultParametersRequest>, DescribeEngineDefaultParametersRequest> {
    @Override
    public Request<DescribeEngineDefaultParametersRequest> marshall(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        if (describeEngineDefaultParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeEngineDefaultParametersRequest> request = new DefaultRequest<DescribeEngineDefaultParametersRequest>(describeEngineDefaultParametersRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeEngineDefaultParameters");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEngineDefaultParametersRequest.getDBParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringUtils.fromString(describeEngineDefaultParametersRequest.getDBParameterGroupFamily()));
        }
        if (!describeEngineDefaultParametersRequest.getFilters().isEmpty() || !((SdkInternalList)describeEngineDefaultParametersRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeEngineDefaultParametersRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeEngineDefaultParametersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeEngineDefaultParametersRequest.getMaxRecords()));
        }
        if (describeEngineDefaultParametersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeEngineDefaultParametersRequest.getMarker()));
        }
        return request;
    }
}

