/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.services.rds.model.DeleteDBClusterRequest;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class DeleteDBClusterRequestMarshaller
implements Marshaller<Request<DeleteDBClusterRequest>, DeleteDBClusterRequest> {
    @Override
    public Request<DeleteDBClusterRequest> marshall(DeleteDBClusterRequest deleteDBClusterRequest) {
        if (deleteDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDBClusterRequest> request = new DefaultRequest<DeleteDBClusterRequest>(deleteDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "DeleteDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(deleteDBClusterRequest.getDBClusterIdentifier()));
        }
        if (deleteDBClusterRequest.getSkipFinalSnapshot() != null) {
            request.addParameter("SkipFinalSnapshot", StringUtils.fromBoolean(deleteDBClusterRequest.getSkipFinalSnapshot()));
        }
        if (deleteDBClusterRequest.getFinalDBSnapshotIdentifier() != null) {
            request.addParameter("FinalDBSnapshotIdentifier", StringUtils.fromString(deleteDBClusterRequest.getFinalDBSnapshotIdentifier()));
        }
        return request;
    }
}

