/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest;
import repackaged.com.amazonaws.services.rds.model.ProcessorFeature;
import repackaged.com.amazonaws.services.rds.model.Tag;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class CreateDBInstanceReadReplicaRequestMarshaller
implements Marshaller<Request<CreateDBInstanceReadReplicaRequest>, CreateDBInstanceReadReplicaRequest> {
    @Override
    public Request<CreateDBInstanceReadReplicaRequest> marshall(CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest) {
        if (createDBInstanceReadReplicaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDBInstanceReadReplicaRequest> request = new DefaultRequest<CreateDBInstanceReadReplicaRequest>(createDBInstanceReadReplicaRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBInstanceReadReplica");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBInstanceReadReplicaRequest.getDBInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString(createDBInstanceReadReplicaRequest.getDBInstanceIdentifier()));
        }
        if (createDBInstanceReadReplicaRequest.getSourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringUtils.fromString(createDBInstanceReadReplicaRequest.getSourceDBInstanceIdentifier()));
        }
        if (createDBInstanceReadReplicaRequest.getDBInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString(createDBInstanceReadReplicaRequest.getDBInstanceClass()));
        }
        if (createDBInstanceReadReplicaRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(createDBInstanceReadReplicaRequest.getAvailabilityZone()));
        }
        if (createDBInstanceReadReplicaRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(createDBInstanceReadReplicaRequest.getPort()));
        }
        if (createDBInstanceReadReplicaRequest.getMultiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getMultiAZ()));
        }
        if (createDBInstanceReadReplicaRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getAutoMinorVersionUpgrade()));
        }
        if (createDBInstanceReadReplicaRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger(createDBInstanceReadReplicaRequest.getIops()));
        }
        if (createDBInstanceReadReplicaRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(createDBInstanceReadReplicaRequest.getOptionGroupName()));
        }
        if (createDBInstanceReadReplicaRequest.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString(createDBInstanceReadReplicaRequest.getDBParameterGroupName()));
        }
        if (createDBInstanceReadReplicaRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getPubliclyAccessible()));
        }
        if (!createDBInstanceReadReplicaRequest.getTags().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBInstanceReadReplicaRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createDBInstanceReadReplicaRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString(createDBInstanceReadReplicaRequest.getDBSubnetGroupName()));
        }
        if (!createDBInstanceReadReplicaRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createDBInstanceReadReplicaRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString(vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBInstanceReadReplicaRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString(createDBInstanceReadReplicaRequest.getStorageType()));
        }
        if (createDBInstanceReadReplicaRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getCopyTagsToSnapshot()));
        }
        if (createDBInstanceReadReplicaRequest.getMonitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringUtils.fromInteger(createDBInstanceReadReplicaRequest.getMonitoringInterval()));
        }
        if (createDBInstanceReadReplicaRequest.getMonitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringUtils.fromString(createDBInstanceReadReplicaRequest.getMonitoringRoleArn()));
        }
        if (createDBInstanceReadReplicaRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(createDBInstanceReadReplicaRequest.getKmsKeyId()));
        }
        if (createDBInstanceReadReplicaRequest.getPreSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString(createDBInstanceReadReplicaRequest.getPreSignedUrl()));
        }
        if (createDBInstanceReadReplicaRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (createDBInstanceReadReplicaRequest.getEnablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getEnablePerformanceInsights()));
        }
        if (createDBInstanceReadReplicaRequest.getPerformanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringUtils.fromString(createDBInstanceReadReplicaRequest.getPerformanceInsightsKMSKeyId()));
        }
        if (createDBInstanceReadReplicaRequest.getPerformanceInsightsRetentionPeriod() != null) {
            request.addParameter("PerformanceInsightsRetentionPeriod", StringUtils.fromInteger(createDBInstanceReadReplicaRequest.getPerformanceInsightsRetentionPeriod()));
        }
        if (!createDBInstanceReadReplicaRequest.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)createDBInstanceReadReplicaRequest.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString(enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (!createDBInstanceReadReplicaRequest.getProcessorFeatures().isEmpty() || !((SdkInternalList)createDBInstanceReadReplicaRequest.getProcessorFeatures()).isAutoConstruct()) {
            SdkInternalList processorFeaturesList = (SdkInternalList)createDBInstanceReadReplicaRequest.getProcessorFeatures();
            int processorFeaturesListIndex = 1;
            for (ProcessorFeature processorFeaturesListValue : processorFeaturesList) {
                if (processorFeaturesListValue.getName() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Name", StringUtils.fromString(processorFeaturesListValue.getName()));
                }
                if (processorFeaturesListValue.getValue() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Value", StringUtils.fromString(processorFeaturesListValue.getValue()));
                }
                ++processorFeaturesListIndex;
            }
        }
        if (createDBInstanceReadReplicaRequest.getUseDefaultProcessorFeatures() != null) {
            request.addParameter("UseDefaultProcessorFeatures", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getUseDefaultProcessorFeatures()));
        }
        if (createDBInstanceReadReplicaRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean(createDBInstanceReadReplicaRequest.getDeletionProtection()));
        }
        if (createDBInstanceReadReplicaRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString(createDBInstanceReadReplicaRequest.getDomain()));
        }
        if (createDBInstanceReadReplicaRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString(createDBInstanceReadReplicaRequest.getDomainIAMRoleName()));
        }
        if (createDBInstanceReadReplicaRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString(createDBInstanceReadReplicaRequest.getSourceRegion()));
        }
        return request;
    }
}

