/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model.transform;

import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.CopyDBClusterParameterGroupRequest;
import repackaged.com.amazonaws.services.rds.model.Tag;
import repackaged.com.amazonaws.transform.Marshaller;
import repackaged.com.amazonaws.util.StringUtils;

public class CopyDBClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDBClusterParameterGroupRequest>, CopyDBClusterParameterGroupRequest> {
    @Override
    public Request<CopyDBClusterParameterGroupRequest> marshall(CopyDBClusterParameterGroupRequest copyDBClusterParameterGroupRequest) {
        if (copyDBClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopyDBClusterParameterGroupRequest> request = new DefaultRequest<CopyDBClusterParameterGroupRequest>(copyDBClusterParameterGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CopyDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBClusterParameterGroupRequest.getSourceDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBClusterParameterGroupIdentifier", StringUtils.fromString(copyDBClusterParameterGroupRequest.getSourceDBClusterParameterGroupIdentifier()));
        }
        if (copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBClusterParameterGroupIdentifier", StringUtils.fromString(copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupIdentifier()));
        }
        if (copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupDescription() != null) {
            request.addParameter("TargetDBClusterParameterGroupDescription", StringUtils.fromString(copyDBClusterParameterGroupRequest.getTargetDBClusterParameterGroupDescription()));
        }
        if (!copyDBClusterParameterGroupRequest.getTags().isEmpty() || !((SdkInternalList)copyDBClusterParameterGroupRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)copyDBClusterParameterGroupRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

