/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import repackaged.com.amazonaws.AmazonWebServiceResult;
import repackaged.com.amazonaws.ResponseMetadata;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.DBInstance;

public class DescribeDBInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<DBInstance> dBInstances;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeDBInstancesResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<DBInstance> getDBInstances() {
        if (this.dBInstances == null) {
            this.dBInstances = new SdkInternalList();
        }
        return this.dBInstances;
    }

    public void setDBInstances(Collection<DBInstance> dBInstances) {
        if (dBInstances == null) {
            this.dBInstances = null;
            return;
        }
        this.dBInstances = new SdkInternalList<DBInstance>(dBInstances);
    }

    public DescribeDBInstancesResult withDBInstances(DBInstance ... dBInstances) {
        if (this.dBInstances == null) {
            this.setDBInstances(new SdkInternalList<DBInstance>(dBInstances.length));
        }
        for (DBInstance ele : dBInstances) {
            this.dBInstances.add(ele);
        }
        return this;
    }

    public DescribeDBInstancesResult withDBInstances(Collection<DBInstance> dBInstances) {
        this.setDBInstances(dBInstances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getDBInstances() != null) {
            sb.append("DBInstances: ").append(this.getDBInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBInstancesResult)) {
            return false;
        }
        DescribeDBInstancesResult other = (DescribeDBInstancesResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getDBInstances() == null ^ this.getDBInstances() == null) {
            return false;
        }
        return other.getDBInstances() == null || other.getDBInstances().equals(this.getDBInstances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstances() == null ? 0 : this.getDBInstances().hashCode());
        return hashCode;
    }

    public DescribeDBInstancesResult clone() {
        try {
            return (DescribeDBInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

