/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import repackaged.com.amazonaws.AmazonWebServiceRequest;
import repackaged.com.amazonaws.internal.SdkInternalList;
import repackaged.com.amazonaws.services.rds.model.Tag;

public class CopyOptionGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceOptionGroupIdentifier;
    private String targetOptionGroupIdentifier;
    private String targetOptionGroupDescription;
    private SdkInternalList<Tag> tags;

    public void setSourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
        this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
    }

    public String getSourceOptionGroupIdentifier() {
        return this.sourceOptionGroupIdentifier;
    }

    public CopyOptionGroupRequest withSourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
        this.setSourceOptionGroupIdentifier(sourceOptionGroupIdentifier);
        return this;
    }

    public void setTargetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
        this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
    }

    public String getTargetOptionGroupIdentifier() {
        return this.targetOptionGroupIdentifier;
    }

    public CopyOptionGroupRequest withTargetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
        this.setTargetOptionGroupIdentifier(targetOptionGroupIdentifier);
        return this;
    }

    public void setTargetOptionGroupDescription(String targetOptionGroupDescription) {
        this.targetOptionGroupDescription = targetOptionGroupDescription;
    }

    public String getTargetOptionGroupDescription() {
        return this.targetOptionGroupDescription;
    }

    public CopyOptionGroupRequest withTargetOptionGroupDescription(String targetOptionGroupDescription) {
        this.setTargetOptionGroupDescription(targetOptionGroupDescription);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public CopyOptionGroupRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CopyOptionGroupRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceOptionGroupIdentifier() != null) {
            sb.append("SourceOptionGroupIdentifier: ").append(this.getSourceOptionGroupIdentifier()).append(",");
        }
        if (this.getTargetOptionGroupIdentifier() != null) {
            sb.append("TargetOptionGroupIdentifier: ").append(this.getTargetOptionGroupIdentifier()).append(",");
        }
        if (this.getTargetOptionGroupDescription() != null) {
            sb.append("TargetOptionGroupDescription: ").append(this.getTargetOptionGroupDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyOptionGroupRequest)) {
            return false;
        }
        CopyOptionGroupRequest other = (CopyOptionGroupRequest)obj;
        if (other.getSourceOptionGroupIdentifier() == null ^ this.getSourceOptionGroupIdentifier() == null) {
            return false;
        }
        if (other.getSourceOptionGroupIdentifier() != null && !other.getSourceOptionGroupIdentifier().equals(this.getSourceOptionGroupIdentifier())) {
            return false;
        }
        if (other.getTargetOptionGroupIdentifier() == null ^ this.getTargetOptionGroupIdentifier() == null) {
            return false;
        }
        if (other.getTargetOptionGroupIdentifier() != null && !other.getTargetOptionGroupIdentifier().equals(this.getTargetOptionGroupIdentifier())) {
            return false;
        }
        if (other.getTargetOptionGroupDescription() == null ^ this.getTargetOptionGroupDescription() == null) {
            return false;
        }
        if (other.getTargetOptionGroupDescription() != null && !other.getTargetOptionGroupDescription().equals(this.getTargetOptionGroupDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceOptionGroupIdentifier() == null ? 0 : this.getSourceOptionGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetOptionGroupIdentifier() == null ? 0 : this.getTargetOptionGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetOptionGroupDescription() == null ? 0 : this.getTargetOptionGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CopyOptionGroupRequest clone() {
        return (CopyOptionGroupRequest)super.clone();
    }
}

