/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.services.rds.auth;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import repackaged.com.amazonaws.AmazonClientException;
import repackaged.com.amazonaws.DefaultRequest;
import repackaged.com.amazonaws.annotation.SdkTestInternalApi;
import repackaged.com.amazonaws.annotation.ThreadSafe;
import repackaged.com.amazonaws.auth.AWS4Signer;
import repackaged.com.amazonaws.auth.AWSCredentialsProvider;
import repackaged.com.amazonaws.auth.SdkClock;
import repackaged.com.amazonaws.auth.StaticSignerProvider;
import repackaged.com.amazonaws.auth.presign.PresignerFacade;
import repackaged.com.amazonaws.auth.presign.PresignerParams;
import repackaged.com.amazonaws.http.HttpMethodName;
import repackaged.com.amazonaws.internal.auth.SignerProvider;
import repackaged.com.amazonaws.regions.Region;
import repackaged.com.amazonaws.services.rds.auth.GetIamAuthTokenRequest;
import repackaged.com.amazonaws.util.ImmutableMapParameter;
import repackaged.com.amazonaws.util.ValidationUtils;
import repackaged.org.joda.time.DateTime;

@ThreadSafe
public class RdsIamAuthTokenGenerator {
    private static final String SERVICE_NAME = "rds-db";
    private static final int DEFAULT_EXPIRATION_IN_MINUTES = 15;
    private final PresignerFacade presignerFacade;
    private final SdkClock clock;

    private RdsIamAuthTokenGenerator(AWSCredentialsProvider credentialsProvider, String region) {
        this(PresignerParams.builder().credentialsProvider(ValidationUtils.assertNotNull(credentialsProvider, "credentialsProvider")).signerProvider(RdsIamAuthTokenGenerator.createSignerProvider(region)).build());
    }

    @SdkTestInternalApi
    RdsIamAuthTokenGenerator(PresignerParams presignerParams) {
        this.presignerFacade = new PresignerFacade(presignerParams);
        this.clock = presignerParams.clock();
    }

    private static SignerProvider createSignerProvider(String region) {
        AWS4Signer signer = new AWS4Signer();
        signer.setRegionName(ValidationUtils.assertStringNotEmpty(region, "region"));
        signer.setServiceName(SERVICE_NAME);
        return new StaticSignerProvider(signer);
    }

    public String getAuthToken(GetIamAuthTokenRequest request) throws AmazonClientException {
        DefaultRequest<Void> signableRequest = new DefaultRequest<Void>(SERVICE_NAME);
        signableRequest.setResourcePath("/");
        this.setEndpoint(signableRequest, request);
        this.setParameters(signableRequest, request);
        signableRequest.setHttpMethod(HttpMethodName.GET);
        return this.presignerFacade.presign(signableRequest, this.getExpirationDate()).toExternalForm().replaceFirst("http://", "");
    }

    private void setEndpoint(DefaultRequest<Void> signableRequest, GetIamAuthTokenRequest request) {
        try {
            signableRequest.setEndpoint(new URI(String.format("http://%s:%d", request.getHostname(), request.getPort())));
        }
        catch (URISyntaxException e) {
            throw new AmazonClientException("Invalid endpoint provided", e);
        }
    }

    private void setParameters(DefaultRequest<Void> signableRequest, GetIamAuthTokenRequest request) {
        signableRequest.setParameters(ImmutableMapParameter.of("DBUser", Collections.singletonList(request.getUserName()), "Action", Collections.singletonList("connect")));
    }

    private Date getExpirationDate() {
        return new DateTime(this.clock.currentTimeMillis()).plusMinutes(15).toDate();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AWSCredentialsProvider credentialsProvider;
        private String region;

        private Builder() {
        }

        public Builder credentials(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder region(Region region) {
            this.region = region.getName();
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public RdsIamAuthTokenGenerator build() {
            return new RdsIamAuthTokenGenerator(this.credentialsProvider, this.region);
        }
    }
}

