/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.retry.v2;

import repackaged.com.amazonaws.retry.v2.RetryCondition;
import repackaged.com.amazonaws.retry.v2.RetryPolicyContext;
import repackaged.com.amazonaws.util.ValidationUtils;

public class MaxNumberOfRetriesCondition
implements RetryCondition {
    private final int maxNumberOfRetries;

    public MaxNumberOfRetriesCondition(int maxNumberOfRetries) {
        this.maxNumberOfRetries = ValidationUtils.assertIsPositive(maxNumberOfRetries, "maxNumberOfRetries");
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return context.retriesAttempted() < this.maxNumberOfRetries;
    }
}

