/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.retry;

import repackaged.com.amazonaws.AmazonClientException;
import repackaged.com.amazonaws.AmazonWebServiceRequest;
import repackaged.com.amazonaws.ClientConfiguration;
import repackaged.com.amazonaws.annotation.SdkInternalApi;
import repackaged.com.amazonaws.retry.RetryMode;
import repackaged.com.amazonaws.retry.RetryPolicy;
import repackaged.com.amazonaws.retry.internal.MaxAttemptsResolver;
import repackaged.com.amazonaws.retry.v2.RetryPolicyContext;
import repackaged.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements repackaged.com.amazonaws.retry.v2.RetryPolicy {
    private final RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;
    private final int maxErrorRetry;

    public RetryPolicyAdapter(RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
        this.maxErrorRetry = this.getMaxErrorRetry();
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return !this.maxRetriesExceeded(context) && this.isRetryable(context);
    }

    public boolean isRetryable(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        Integer resolvedMaxAttempts = new MaxAttemptsResolver().maxAttempts();
        if (resolvedMaxAttempts != null) {
            return resolvedMaxAttempts - 1;
        }
        if (this.shouldUseStandardModeDefaultMaxRetry()) {
            return 2;
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }

    private boolean shouldUseStandardModeDefaultMaxRetry() {
        RetryMode retryMode = this.clientConfiguration.getRetryMode() == null ? this.legacyRetryPolicy.getRetryMode() : this.clientConfiguration.getRetryMode();
        return retryMode.equals((Object)RetryMode.STANDARD) && this.legacyRetryPolicy.isDefaultMaxErrorRetryInRetryModeHonored();
    }

    public boolean maxRetriesExceeded(RetryPolicyContext context) {
        return context.retriesAttempted() >= this.maxErrorRetry;
    }
}

