/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.regions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.auth.AWSCredentialsProviderChain;
import repackaged.com.amazonaws.regions.AwsRegionProvider;
import repackaged.org.apache.commons.logging.Log;
import repackaged.org.apache.commons.logging.LogFactory;

public class AwsRegionProviderChain
extends AwsRegionProvider {
    private static final Log LOG = LogFactory.getLog(AWSCredentialsProviderChain.class);
    private final List<AwsRegionProvider> providers;

    public AwsRegionProviderChain(AwsRegionProvider ... providers) {
        this.providers = new ArrayList<AwsRegionProvider>(providers.length);
        Collections.addAll(this.providers, providers);
    }

    @Override
    public String getRegion() throws SdkClientException {
        for (AwsRegionProvider provider : this.providers) {
            try {
                String region = provider.getRegion();
                if (region == null) continue;
                return region;
            }
            catch (Exception e) {
                LOG.debug("Unable to load region from " + provider.toString() + ": " + e.getMessage());
            }
        }
        throw new SdkClientException("Unable to load region information from any provider in the chain");
    }
}

