/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.protocol.json.internal;

import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.annotation.SdkInternalApi;
import repackaged.com.amazonaws.protocol.MarshallLocation;
import repackaged.com.amazonaws.protocol.MarshallingInfo;
import repackaged.com.amazonaws.protocol.MarshallingType;
import repackaged.com.amazonaws.protocol.ProtocolMarshaller;
import repackaged.com.amazonaws.protocol.json.StructuredJsonGenerator;
import repackaged.com.amazonaws.protocol.json.internal.JsonProtocolMarshaller;
import repackaged.com.amazonaws.protocol.json.internal.MarshallerRegistry;

@SdkInternalApi
public class JsonMarshallerContext {
    private final StructuredJsonGenerator jsonGenerator;
    private final JsonProtocolMarshaller protocolHandler;
    private final MarshallerRegistry marshallerRegistry;
    private final Request<?> request;

    private JsonMarshallerContext(Builder builder) {
        this.jsonGenerator = builder.jsonGenerator;
        this.protocolHandler = builder.protocolHandler;
        this.marshallerRegistry = builder.marshallerRegistry;
        this.request = builder.request;
    }

    public StructuredJsonGenerator jsonGenerator() {
        return this.jsonGenerator;
    }

    public ProtocolMarshaller protocolHandler() {
        return this.protocolHandler;
    }

    public MarshallerRegistry marshallerRegistry() {
        return this.marshallerRegistry;
    }

    public Request<?> request() {
        return this.request;
    }

    public void marshall(MarshallLocation marshallLocation, Object val) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, null);
    }

    public void marshall(MarshallLocation marshallLocation, Object val, MarshallingInfo marshallingInfo) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, marshallingInfo);
    }

    public void marshall(MarshallLocation marshallLocation, Object val, String paramName) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, MarshallingInfo.builder(new MarshallingType<Object>(){

            @Override
            public boolean isDefaultMarshallerForType(Class<?> type) {
                return false;
            }
        }).marshallLocationName(paramName).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StructuredJsonGenerator jsonGenerator;
        private JsonProtocolMarshaller protocolHandler;
        private MarshallerRegistry marshallerRegistry;
        private Request<?> request;

        private Builder() {
        }

        public Builder jsonGenerator(StructuredJsonGenerator jsonGenerator) {
            this.jsonGenerator = jsonGenerator;
            return this;
        }

        public Builder protocolHandler(JsonProtocolMarshaller protocolHandler) {
            this.protocolHandler = protocolHandler;
            return this;
        }

        public Builder marshallerRegistry(MarshallerRegistry marshallerRegistry) {
            this.marshallerRegistry = marshallerRegistry;
            return this;
        }

        public Builder request(Request<?> request) {
            this.request = request;
            return this;
        }

        public JsonMarshallerContext build() {
            return new JsonMarshallerContext(this);
        }
    }
}

