/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.internal.http;

import java.util.Arrays;
import repackaged.com.amazonaws.annotation.SdkInternalApi;
import repackaged.com.amazonaws.http.HttpResponse;
import repackaged.com.amazonaws.internal.http.ErrorCodeParser;
import repackaged.com.amazonaws.protocol.json.JsonContent;

@SdkInternalApi
public class CompositeErrorCodeParser
implements ErrorCodeParser {
    private final Iterable<ErrorCodeParser> parsers;

    public CompositeErrorCodeParser(Iterable<ErrorCodeParser> parsers) {
        this.parsers = parsers;
    }

    public CompositeErrorCodeParser(ErrorCodeParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public String parseErrorCode(HttpResponse response, JsonContent jsonContent) {
        for (ErrorCodeParser parser : this.parsers) {
            String errorCode = parser.parseErrorCode(response, jsonContent);
            if (errorCode == null) continue;
            return errorCode;
        }
        return null;
    }
}

