/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.http.apache.client.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import repackaged.com.amazonaws.SDKGlobalConfiguration;
import repackaged.com.amazonaws.http.AmazonHttpClient;
import repackaged.com.amazonaws.http.DelegatingDnsResolver;
import repackaged.com.amazonaws.http.SystemPropertyTlsKeyManagersProvider;
import repackaged.com.amazonaws.http.TlsKeyManagersProvider;
import repackaged.com.amazonaws.http.client.ConnectionManagerFactory;
import repackaged.com.amazonaws.http.conn.SdkPlainSocketFactory;
import repackaged.com.amazonaws.http.conn.ssl.SdkTLSSocketFactory;
import repackaged.com.amazonaws.http.settings.HttpClientSettings;
import repackaged.com.amazonaws.internal.SdkSSLContext;
import repackaged.org.apache.commons.logging.Log;
import repackaged.org.apache.commons.logging.LogFactory;
import repackaged.org.apache.http.HttpHost;
import repackaged.org.apache.http.config.ConnectionConfig;
import repackaged.org.apache.http.config.Registry;
import repackaged.org.apache.http.config.RegistryBuilder;
import repackaged.org.apache.http.config.SocketConfig;
import repackaged.org.apache.http.conn.HttpClientConnectionManager;
import repackaged.org.apache.http.conn.socket.ConnectionSocketFactory;
import repackaged.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import repackaged.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import repackaged.org.apache.http.impl.conn.DefaultSchemePortResolver;
import repackaged.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import repackaged.org.apache.http.protocol.HttpContext;

public class ApacheConnectionManagerFactory
implements ConnectionManagerFactory<HttpClientConnectionManager> {
    private final Log LOG = LogFactory.getLog(AmazonHttpClient.class);

    @Override
    public HttpClientConnectionManager create(HttpClientSettings settings) {
        ConnectionSocketFactory sslsf = this.getPreferredSocketFactory(settings);
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.createSocketFactoryRegistry(sslsf), null, DefaultSchemePortResolver.INSTANCE, new DelegatingDnsResolver(settings.getDnsResolver()), settings.getConnectionPoolTTL(), TimeUnit.MILLISECONDS);
        cm.setValidateAfterInactivity(settings.getValidateAfterInactivityMillis());
        cm.setDefaultMaxPerRoute(settings.getMaxConnections());
        cm.setMaxTotal(settings.getMaxConnections());
        cm.setDefaultSocketConfig(this.buildSocketConfig(settings));
        cm.setDefaultConnectionConfig(this.buildConnectionConfig(settings));
        return cm;
    }

    private ConnectionSocketFactory getPreferredSocketFactory(HttpClientSettings settings) {
        ConnectionSocketFactory sslsf = settings.getApacheHttpClientConfig().getSslSocketFactory();
        return sslsf != null ? sslsf : new SdkTLSSocketFactory(SdkSSLContext.getPreferredSSLContext(this.getKeyManagers(settings), settings.getSecureRandom()), this.getHostNameVerifier(settings));
    }

    private SocketConfig buildSocketConfig(HttpClientSettings settings) {
        return SocketConfig.custom().setSoKeepAlive(settings.useTcpKeepAlive()).setSoTimeout(settings.getSocketTimeout()).setTcpNoDelay(true).build();
    }

    private ConnectionConfig buildConnectionConfig(HttpClientSettings settings) {
        int socketBufferSize = Math.max(settings.getSocketBufferSize()[0], settings.getSocketBufferSize()[1]);
        return socketBufferSize <= 0 ? null : ConnectionConfig.custom().setBufferSize(socketBufferSize).build();
    }

    private KeyManager[] getKeyManagers(HttpClientSettings settings) {
        TlsKeyManagersProvider provider = settings.getTlsKeyMangersProvider();
        if (provider == null) {
            provider = new SystemPropertyTlsKeyManagersProvider();
        }
        return provider.getKeyManagers();
    }

    private HostnameVerifier getHostNameVerifier(HttpClientSettings options) {
        return options.useBrowserCompatibleHostNameVerifier() ? SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory sslSocketFactory) {
        if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
            if (this.LOG.isWarnEnabled()) {
                this.LOG.warn("SSL Certificate checking for endpoints has been explicitly disabled.");
            }
            sslSocketFactory = new TrustingSocketFactory();
        }
        return RegistryBuilder.create().register("http", new SdkPlainSocketFactory()).register("https", (SdkPlainSocketFactory)sslSocketFactory).build();
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements LayeredConnectionSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return context;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(socket, target, port, true);
        }

        @Override
        public Socket createSocket(HttpContext context) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        @Override
        public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket(context));
            if (localAddress != null) {
                sslsock.bind(localAddress);
            }
            sslsock.connect(remoteAddress, connectTimeout);
            return sslsock;
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }
    }
}

