/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import repackaged.com.amazonaws.AmazonWebServiceRequest;
import repackaged.com.amazonaws.Request;
import repackaged.com.amazonaws.Response;
import repackaged.com.amazonaws.annotation.ThreadSafe;
import repackaged.com.amazonaws.handlers.HandlerAfterAttemptContext;
import repackaged.com.amazonaws.handlers.HandlerBeforeAttemptContext;
import repackaged.com.amazonaws.handlers.IRequestHandler2;
import repackaged.com.amazonaws.handlers.RequestHandler2;
import repackaged.com.amazonaws.http.HttpResponse;
import repackaged.com.amazonaws.util.ValidationUtils;

@ThreadSafe
public class StackedRequestHandler
implements IRequestHandler2 {
    private final List<RequestHandler2> inOrderRequestHandlers;
    private final List<RequestHandler2> reverseOrderRequestHandlers;

    public StackedRequestHandler(RequestHandler2 ... requestHandlers) {
        this(Arrays.asList((Object[])ValidationUtils.assertNotNull(requestHandlers, "requestHandlers")));
    }

    public StackedRequestHandler(List<RequestHandler2> requestHandlers) {
        this.inOrderRequestHandlers = ValidationUtils.assertNotNull(requestHandlers, "requestHandlers");
        this.reverseOrderRequestHandlers = new ArrayList<RequestHandler2>(requestHandlers);
        Collections.reverse(this.reverseOrderRequestHandlers);
    }

    @Override
    public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest origRequest) {
        AmazonWebServiceRequest toReturn = origRequest;
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            toReturn = handler.beforeExecution(toReturn);
        }
        return toReturn;
    }

    @Override
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest origRequest) {
        AmazonWebServiceRequest toReturn = origRequest;
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            toReturn = handler.beforeMarshalling(toReturn);
        }
        return toReturn;
    }

    @Override
    public void beforeRequest(Request<?> request) {
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            handler.beforeRequest(request);
        }
    }

    @Override
    public void beforeAttempt(HandlerBeforeAttemptContext context) {
        for (RequestHandler2 handler : this.inOrderRequestHandlers) {
            handler.beforeAttempt(context);
        }
    }

    @Override
    public HttpResponse beforeUnmarshalling(Request<?> request, HttpResponse origHttpResponse) {
        HttpResponse toReturn = origHttpResponse;
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            toReturn = handler.beforeUnmarshalling(request, toReturn);
        }
        return toReturn;
    }

    @Override
    public void afterAttempt(HandlerAfterAttemptContext context) {
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            handler.afterAttempt(context);
        }
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            handler.afterResponse(request, response);
        }
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception e) {
        for (RequestHandler2 handler : this.reverseOrderRequestHandlers) {
            handler.afterError(request, response, e);
        }
    }
}

