/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.auth.profile.internal;

import repackaged.com.amazonaws.SdkClientException;
import repackaged.com.amazonaws.annotation.Immutable;
import repackaged.com.amazonaws.annotation.SdkInternalApi;
import repackaged.com.amazonaws.auth.AWSCredentials;
import repackaged.com.amazonaws.auth.AWSCredentialsProvider;
import repackaged.com.amazonaws.auth.profile.internal.AllProfiles;
import repackaged.com.amazonaws.auth.profile.internal.BasicProfile;
import repackaged.com.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import repackaged.com.amazonaws.auth.profile.internal.securitytoken.ProfileCredentialsService;
import repackaged.com.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import repackaged.com.amazonaws.util.StringUtils;

@SdkInternalApi
@Immutable
public class ProfileAssumeRoleCredentialsProvider
implements AWSCredentialsProvider {
    private final AllProfiles allProfiles;
    private final BasicProfile profile;
    private final ProfileCredentialsService profileCredentialsService;
    private final AWSCredentialsProvider assumeRoleCredentialsProvider;

    public ProfileAssumeRoleCredentialsProvider(ProfileCredentialsService profileCredentialsService, AllProfiles allProfiles, BasicProfile profile) {
        this.allProfiles = allProfiles;
        this.profile = profile;
        this.profileCredentialsService = profileCredentialsService;
        this.assumeRoleCredentialsProvider = this.fromAssumeRole();
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.assumeRoleCredentialsProvider.getCredentials();
    }

    @Override
    public void refresh() {
    }

    private AWSCredentialsProvider fromAssumeRole() {
        if (StringUtils.isNullOrEmpty(this.profile.getRoleSourceProfile())) {
            throw new SdkClientException(String.format("Unable to load credentials from profile [%s]: Source profile name is not specified", this.profile.getProfileName()));
        }
        BasicProfile sourceProfile = this.allProfiles.getProfile(this.profile.getRoleSourceProfile());
        if (sourceProfile == null) {
            throw new SdkClientException(String.format("Unable to load source profile [%s]: Source profile was not found [%s]", this.profile.getProfileName(), this.profile.getRoleSourceProfile()));
        }
        AWSCredentials sourceCredentials = new ProfileStaticCredentialsProvider(sourceProfile).getCredentials();
        String roleSessionName = this.profile.getRoleSessionName() == null ? "aws-sdk-java-" + System.currentTimeMillis() : this.profile.getRoleSessionName();
        RoleInfo roleInfo = new RoleInfo().withRoleArn(this.profile.getRoleArn()).withRoleSessionName(roleSessionName).withExternalId(this.profile.getRoleExternalId()).withLongLivedCredentials(sourceCredentials).withWebIdentityTokenFilePath(this.profile.getWebIdentityTokenFilePath());
        return this.profileCredentialsService.getAssumeRoleCredentialsProvider(roleInfo);
    }
}

